function pathck(p)

% PATHCK   check path for redondant m-files
%	PATHCK checks the MatLab path for redondant m-,mex-,p-files
%	PATHCK(PATH) allows to specify the path.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 1, p = path; end

p = sep2mat(p,',');
ptype = repmat('u',size(p,1),1);
ptype(strmatch('toolbox:',p)) = 't';
ptype(strmatch('toolbox:[matlab',p)) = 'm';
ptype(strmatch('toolbox:[local', p)) = 'l';
        
f = ''; fp = [];
for k = 1:size(p,1)
 w = what(p(k,:));
 f = strvcat(f,char(w.m),char(w.mex),char(w.p));
 fp = [fp;repmat(k,length(w.m)+length(w.mex)+length(w.p),1)];
end
k = strmatch('contents',f); f(k,:) = ''; fp(k) = [];
k = strmatch('readme',  f); f(k,:) = ''; fp(k) = [];
k = strmatch('demos',   f); f(k,:) = ''; fp(k) = [];
[f,k] = sortrows(f); fp = fp(k);
fname = f;
for k = 1:size(f,1)
 fname(k,find(f(k,:) == '.'):end) = ' ';
end

k = find(all(diff(fname) == 0,2)); k(diff(k) == 1) = [];
fdup = fname(k,:);

for k = 1:size(fdup,1)
 l = strmatch(fdup(k,:),fname,'exact')';
 if any(diff(fp(l)) ~= 0)
  ff = deblank(fdup(k,:));
  if any(ptype(fp(l)) == 'u') & any(ptype(fp(l)) == 't')
   fprintf('\nYou may shadow "%s" and LOCK A LICENSE KEY\n',ff)
  elseif any(ptype(fp(l)) == 'u')
   fprintf('\nYou may shadow "%s"\n',ff)
  elseif any(ptype(fp(l)) == 'l')
   fprintf('\nYour Matlab manager may shadow "%s"\n',ff)
  else
   fprintf('\nMathworks may shadow "%s"\n',ff)
  end
  for l = l
   fprintf('%30s%s\n',deblank(p(fp(l),:)),f(l,:))
  end
 end
end
