/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "genlib.h"
# include <string.h>

void mexFunction(int nlhs,       mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{

# define MEXNAME cs2devalmex

 /* [v,vx,vy,vxx,vxy,vyy,vxxx,vxxy,vxyy,vyyy] = cs2devalmex(xk,yk,c,x,y,d); */

# define MXV    pout[0]
# define MXVX   pout[1]
# define MXVY   pout[2]
# define MXVXX  pout[3]
# define MXVXY  pout[4]
# define MXVYY  pout[5]
# define MXVXXX pout[6]
# define MXVXXY pout[7]
# define MXVXYY pout[8]
# define MXVYYY pout[9]

# define MXTX  prhs[0] /* double */
# define MXTY  prhs[1] /* double */
# define MXC   prhs[2] /* double */
# define MXXP  prhs[3] /* double, def size=np */
# define MXYP  prhs[4] /* double,     size=np */
# define MXD   prhs[5] /* double */

 CHECK_NARGIN_EQ(6);

 int np = mxGetNumberOfElements(MXXP);

 CHECK_DOUBLE(MXTX);
 CHECK_DOUBLE(MXTY);
 CHECK_DOUBLE(MXC);
 CHECK_DOUBLE(MXXP);
 CHECK_DOUBLE(MXYP);
 CHECK_NUMEL(MXYP,np);
 CHECK_DOUBLE(MXD);

 CHECK_NARGOUT_LE(10);

 mxArray *pout[10] = {NULL};

 int nTx, nTy, nCx, nCy, kx, ky, ndX;
 const mwSize *dimX;
 double *V, *Vx, *Vy, *Vxx, *Vxy, *Vyy, *Vxxx, *Vxxy, *Vxyy, *Vyyy;
 double *Tx, *Ty, *C, *xp, *yp;
 double idx, idy;
 int dmax, nd, id;
 double *d;

 /* size management */
 nTx  = mxGetNumberOfElements(MXTX);
 nTy  = mxGetNumberOfElements(MXTY);
 nCx  = mxGetM(MXC);
 nCy  = mxGetN(MXC);
 ndX  = mxGetNumberOfDimensions(MXXP);
 dimX = mxGetDimensions(MXXP);

 /* Determine order of B-spline */
 kx = nTx - nCx;
 ky = nTy - nCy;
 if ((kx != 4) || (ky != 4)) mexErrMsgIdAndTxt("cs2devalmex:order","Expecting 2d cubic splines");

 /* Determine maximum derivative order */ 
 d  = mxGetPr(MXD);
 nd = mxGetNumberOfElements(MXD);
 dmax = -1;
 for (id = 0; id < nd; id++)
   if (d[id] > dmax)
     dmax = d[id];

 /* output memory allocation */
 V = mxGetPr(MXV = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
 Vx = Vy = Vxx = Vxy = Vyy = Vxxx = Vxxy = Vxyy = Vyyy = NULL;
 if (nlhs>1)
 {
   Vx = mxGetPr(MXVX = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vy = mxGetPr(MXVY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
 }
 if (nlhs>3)
 {
   Vxx = mxGetPr(MXVXX = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vxy = mxGetPr(MXVXY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vyy = mxGetPr(MXVYY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
 }
 if (nlhs>6)
 {
   Vxxx = mxGetPr(MXVXXX = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vxxy = mxGetPr(MXVXXY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vxyy = mxGetPr(MXVXYY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
   Vyyy = mxGetPr(MXVYYY = mxCreateNumericArray(ndX, dimX, mxDOUBLE_CLASS, mxREAL));
 }
 
 Tx = mxGetPr(MXTX);
 Ty = mxGetPr(MXTY);
 C  = mxGetPr(MXC );
 xp = mxGetPr(MXXP);
 yp = mxGetPr(MXYP);
 
 idx = Tx[1] - Tx[0];
 idy = Ty[1] - Ty[0];
 idx = idx ? 1./idx : 0.0;
 idy = idy ? 1./idy : 0.0;

 /* do the work */
 cs2deval(V, Vx, Vy, Vxx, Vxy, Vyy,
          Vxxx, Vxxy, Vxyy, Vyyy,
          Tx, nTx, Ty, nTy, C, nCx, nCy,
          xp, yp, np, dmax, idx, idy);
 
 ASSIGN_PLHS;
}
