function k = iround(t,x,sortflag)

% IROUND	Index of the nearest element
%   IROUND(T,X) returns the index of the nearest element in the monotonic
%   increasing table T for each value of X. Call IROUND with a 3rd argument if X
%   is non monotonic.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 3
 sortflag = 0;
end
if sortflag
 [x,ksort] = sort(x);
end
k = iflooriceiliroundmex(t,x,int32(0));
if sortflag
 k(ksort) = k;
end
