/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# ifndef GENLIB_H

# define GENLIB_H

# if defined MATLAB_MEX_FILE || defined OCTAVE_MEX_FILE

 # include "mex.h"
 # include "../mexargs/include/mexargs.h"

# endif

/* Define a type equivalent to bool
 * Altough on Linux MATLAB's mxLogical is identical to bool, 
 * this is not true for all platform and also not for Octave
 * but most importantly Simulink's boolean_T type is not the
 * same as mxLogical and is unsigned char instead.
 * The following solution should work for our limited use of
 * boolean types */
typedef unsigned char genlib_bool;
# define genlib_true ((genlib_bool)(1))
# define genlib_false ((genlib_bool)(0))

void bspbase(double *B, double *T, int sizeT, int k, double *X, int sizeX);
void bspsum(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
# ifdef BSPSUM4
void bspsum40(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
void bspsum41(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
void bspsum42(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
# endif
double ellipfast(double y, int kind);
void greenem(int *mode, int nm, genlib_bool der1, genlib_bool der2, double r1, double z1, double r2, double z2, double **y, int o);

void iceil(int *k, double *T, int sizeT, double *X, int sizeX);
void ifloor(int *k, double *T, int sizeT, double *X, int sizeX);
void iround(int *k, double *T, int sizeT, double *X, int sizeX);

void csint(double *c0, double *c1, double *c2, double *c3, double rho, int d,double fac);

void adotc(double *c0, double *c1, double *c2, double *c3,
           double a0, double a1, double a2, double a3,
           double *C, int ix, int iy, int nCx);

void cs2deval(double *V, double *Vx, double *Vy, double *Vxx, double *Vxy, double *Vyy,
              double *Vxxx, double *Vxxy, double *Vxyy, double *Vyyy,
              double *Tx, int nTx, double *Ty, int nTy, double *C, int nCx, int nCy,
              double *xp, double *yp, int np, int dmax, double idx, double idy);

# endif
