% BSPSUM   B-spline base function combination
%   BSPSUM(T,C,X) estimates at each X the combination of spline base functions
%   defined by the knot sequence T. C contains along its first dimension the
%   coefficients of the combination, and BSPSUM returns an array of size
%   [size(X),size(C)(2:end)] or [numel(X),size(C)(2:end)] if X is a vector.
%   BSPSUM(T,C,X,D) allows to estimate the D-th derivative.
%   BSPSUM(T,C,X,D,1) expects a C of size [size(C,1),size(X),DIM] and
%   returns an array of size [size(X),DIM], having applied the corresponding
%   coefficient to the corresponding X value.
%   BSPSUM(T,C,X,*,*,NPAR) specifies the number of threads for parallel
%   evaluation. The default value for NPAR is 1.
%   Spline order K is numel(T)-size(C,1).
%   BSPSUM uses a MEX-file much faster than SPVAL in the Spline Toolbox.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% test:  plot(bspsum(-2:12,eye(12,15),linspace(0,10,101)))
