%FSG2MEX  Flux surface geometrical integrals continued
%   [VQ,AQ] = FSG2(aq,RA,CRQ,DOQ)
%
% Computes the flux-surface volume VQ and cross-section area AQ based on
% the contour minor radius aQ(rh,th), magnetic axis major radius RA.
% CRQ=-cos(OQ) such that RQ = RA+CRQ*aQ and DOQ is the grid spacing for
% the poloidal angle.
%
% The formulas are:
%  - VQ  = int(RQ*aQ*daQdrh drh.dth.dphi) = 2*pi int((RA/3 - aQ*cos(th)/2)*aQ^2 dth)
%  - AQ  = int(   aQ*daQdrh drh.dth     ) =      int(                 1/2 *aQ^2 dth)
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [VQ,AQ] = fsg2mex(aq,rA,crq,doq)
  warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)

  [VQ,AQ] = fsg2mexm(aq,rA,crq,doq);

end
