function [dFl] = flcsJac(rl,zl,L)
% FLCSJAC Compute derivatives of Fl output of flcs with respect to Fx
%
%   [dFl] = flcsJac(rl,zl,L)
%
% A 2D spline interpolation at a point rl,zl is the result of:
%  Fl = B*(A*CFx).' with B and A the vectors for interpolation in the Z and
%  R direction and CFx the matrix of spline coefficients describing Fx
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

rk = L.taur;
zk = L.tauz;

ns = numel(rl);
dFl = zeros(ns,L.nx);

irs = min(max(floor((rl-rk(1))*L.idrx)+1,4),L.nrx+3);
izs = min(max(floor((zl-zk(1))*L.idzx)+1,4),L.nzx+3);

drs = (rl-rk(irs))*L.idrx;
dzs = (zl-zk(izs))*L.idzx;

for is = 1:ns
  ir = irs(is);
  iz = izs(is);
  dr = drs(is);
  dz = dzs(is);
  
  % R-interpolation
  A = csint_helper(dr,0);
  Ar = A*L.Mr(ir-3:ir,:);

  % Z-interpolation
  B = csint_helper(dz,0);
  Bz = B*L.Mz(iz-3:iz,:);
  
  dFl(is,:) = reshape(Bz.'*Ar,1,L.nx);
end

end
