%FL4PMEX  Four point interpolation for the flux on the limiter
% [FL,DRFL,DZFL] = FL4PMEX(FX,KL,CL,FN) computes with a four point
% interpolation the flux on the limiter. KL is the 0-based index of the
% reference grid point (R,Z), and the coefficients to be used at the four
% points:
%   FL = C(1,:)*FX(R,Z)+C(2,:)*(R+DR,Z)+C(3,:)*(R+DR,Z+DZ)+C(4,:)*(R,Z+DZ)
% All points but the extrema compatible with the sign of FN are tagged
% with FN. The gradients in the R and Z direction are also computed to
% later dismiss points with a positive gradient in the direction away
% from the plasma axis corresponding to the private flux region.
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015], Section 4.3
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [Fl,drFl,dzFl] = fl4pmex(Fx,kl,cl,FN)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [Fl,drFl,dzFl] = fl4pmexm(Fx,kl,cl,FN);
 
end
