function LX = fgsxana(t,L)
% FGSXANA - Data loading for FGS anamak
% LX = fgsxana(t,L)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

fields_to_rm = {'iterq','algoNL','fastcoil','Ipmin','cde','argout',...
  'jacobian_handle','jacobian_sparse','algoGMRES','userowmask',...
  'mkryl','usepreconditioner'};
P = rmfield(L.P,fields_to_rm(isfield(L.P,fields_to_rm)));
PP = [fieldnames(P),struct2cell(P)]';          % pass L parameters as fbt inputs
[Lfbt,~,LXfbt] = fbt('ana',L.P.shot,t,PP{:});  % equilibria from FBT
assert(~isempty(LXfbt) && all(LXfbt.isconverged),'FBT did not converge')
% Convert to target L structure format
LX = meqxconvert(Lfbt,LXfbt,L);
end
