function P = fgspana(shot,varargin)
% defines FGS parameters and append user parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

P = meqpana(shot);
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end

%% defaults
D.insrc = 'fgs';
D.selu = 'v'; % vessel filament description by default

% Shot dependent defaults
if shot == 88
  % Plasma constraints
  D.agcon = {{'Ip','Wk','qA'},{'Ip','Wk','qA'},{'Ip','Wk'}};
end

% substitute defaults where necessary
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P.shot = shot;

end
