function [dLY_dIa,dLY_dIu,dLY_dCo] = fgslin_full(L,LY)
% [dLY_dIa,dLY_dIa,dLY_dCo] = fgslin_full(L,LY);
% Linearized static equilibrium.
% Computes dLY/dIa (derivative of LY w.r.t. a coil current)
% and dLY_dCo (derivative of LY w.r.t. ag constraint quantities)
% Based on finite differences. Counterpart of fgslin for checking etc.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% initial state
LX = LY;
linfields = fieldnames(LY);
nfields = numel(linfields);
dLY = cell(nfields,1);

% Initial arguments
L.P.debug=0; % silence these repetitive calls
x0 = {L,LX,LX.Ia,LX.Iu,LX2Co(L,LX)};
F0 = struct2cell(LY);
szF0 = sizes_LY(F0);

% coils currents
dIa = 1e-4*abs(LX.Ip); % Ia perturbations to consider [A]
[dLY{:}] = jacfd(@fgst_fields,x0,'F0',F0,'szF0',szF0,'iargin',3,'epsval',dIa);
dLY_dIa = cell2struct(dLY,linfields);

% vessel currents
dIu = 1e-4*abs(LY.Ip); % Iu perturbations to consider [A]
[dLY{:}] = jacfd(@fgst_fields,x0,'F0',F0,'szF0',szF0,'iargin',4,'epsval',dIu);
dLY_dIu = cell2struct(dLY,linfields);

% Derivatives w.r.t. quantities in LX that define ag constraints (via meqagcon)
dCo = 1e-4*abs(x0{5});
[dLY{:}] = jacfd(@fgst_fields,x0,'F0',F0,'szF0',szF0,'iargin',5,'epsval',dCo);
dLY_dCo = cell2struct(dLY,linfields);
end

function szF0 = sizes_LY(F0)
% Get list of sizes for values of LY
nfields = numel(F0);
szF0 = cell(1,nfields);
for ii = 1:nfields
  val = F0{ii};
  if isscalar(val) || iscolumn(val)
    % scalar or vector
    szF0{ii} = numel(val);
  else
    szF0{ii} = size(val);
  end
end
end

function varargout = fgst_fields(L,LX,Ia,Iu,Co)
% Update LX
LX.Ia = Ia;
LX.Iu = Iu;
LX = Co2LX(L,LX,Co);
% Run fgst and separate all LY fields
LY_cell = struct2cell(fgst(L,LX));
varargout = LY_cell(1:nargout);
end
