function G = fgsgtcv(shot, P)
%FGSGTCV  TCV Forward-LIUQE geometry and electromagnetic parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

switch P.selu
  case {'v','e'}
    xargs = {'Muu','Mxu'}; % request optional extra outputs
  case {'s'}
    xargs = {'Mxs'};
  otherwise
    xargs = {};
end

P.shot = shot;
sels = []; sell = []; self = []; selm = [];
G = meqgtcv(P,P.sela,sels,sell,self,selm,P.selx,P.selu,P.selc,xargs{:});
end
