function [Prec,Jx] = fgepre(L,LX,P,dt)
% Computes preconditioner for FGE using lin terms
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if strcmp(P.prectype,'user')
  Jx = []; % Jx not needed
else
  if L.isEvolutive && dt
    % fgeFlin calls fgeF with LXt=LX, LYp=LX so that Jx is computed with dt=0
    [~,Jx,~,Jxdot] = fgeFlin(L,LX);
    Jx(L.ind.irD,:) = Jx(L.ind.irD,:) + 1/dt*Jxdot;
  else
    [~,Jx] = fgeFlin(L,LX);
  end
end

Prec = preconditioner_init(P,Jx,L.nN);

end
