function [Ei,Vi,LYi] = fgeploteig(L,varargin)
% FGEPLOTEIG Plots unstable eigenmodes from fgeeig
% [Ei,Vi,LYi] = fgeploteig(L,varargin)
%
% Calls fgeeig, see FGEEIG for details
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

[Ei,Vi,LYi] = fgeeig(L,varargin{:});
nmodes = numel(Ei);

for jj=1:nmodes
  if nmodes>1
    subplot(1,nmodes,jj);
  end
  
  cla;
  imagesc(L.ry,L.zy,LYi(jj).Iy,'AlphaData',abs(LYi(jj).Iy)>eps); hold on;  axis tight;  
  
  if L.P.izgrid
    meqplotfancy(L,LYi(jj),'FxLevels',16,'vacuum',true);
  else
    contour(L.rx,L.zx,LYi(jj).Fx,21,'linecolor',0.5*[1 1 1]);
  end
  set(gca,'clim',[min(LYi(jj).Iy(:)) max(LYi(jj).Iy(:))]);
  
  axis(gca,'equal','xy');
  if Ei(jj)>0
    title(sprintf('unstable mode, \\gamma=%2.2f',Ei(jj)))
  else
    title(sprintf('  stable mode, \\gamma=%2.2f',Ei(jj)))
  end
end
