function G = fgegtcv(shot, P, xargs)
%FGEGTCV  TCV Forward-LIUQE time evolution geometry and electromagnetic parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if nargin<3, xargs = {};end

switch P.selu(1)
  case {'v','e'}
    xargs = [{'Maa','Ra','Mau','Muu','Mxu'},xargs];
   case {'s','n'}
    error('FGE:INVALIDVESSELMODE','selu=''%s'' not supported for fge',P.selu)
  otherwise
    error('unrecognised vessel option');
end

P.shot = shot;
sels = []; sell = []; self = []; selm = [];
G = meqgtcv(P,P.sela,sels,sell,self,selm,P.selx,P.selu,P.selc,xargs{:});

%% Power supply delays (to discuss a better place to put these)
G.Vadelay = zeros(numel(G.dima),1);
G.Vadelay(startsWith(G.dima,{'E','F','OH'})) = 0.5e-3;
G.Vadelay(startsWith(G.dima,{'G'})) = 0.5e-4;
end
