function G = fgeg(G,P,varargin)
%% G = fgeg(G,P) 
% fge geometry and electromagnetic parameters defines missing fields in the
% structure G using parameters
% See also fgeg, fgsg, meqg
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

xargs = [varargin,{'Maa','Mau','Muu','Ra','Ru'}]; % add extra quantities to retrieve

G = meqg(G,P,xargs{:});

if ~isfield(G,'Vadelay')
  G.Vadelay = zeros(G.na,1); % Default Voltage power supply delays
end
end
