function L = fgec(P,G)
% FGEC Parameter consolidation for fge
% L = fgec(P,G)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% Generic fgsc ancilliary data (includes meqc)
L = fgsc(P,G,true); % call fgsc with isEvolutive=true

%% Code specific functions
L.codeinit = @fgeinit; % Initialise the equilibrium based on fgeinit.m
L.codeFlin = @fgeFlin; % Linearized operator
L.code = 'fge';

%% CDE functions
[L.cdec, L.icde, L.np] = meqcdec(P.cde,L.agconc,L.fTg,L.TDg,L.nD,true);
assert(L.nC + L.np == L.ng,...
  'Number of ag constraints (%d) and CDE residuals (%d) must match number of basis functions (%d)',...
  L.nC,L.np,L.ng)

%% NL model setup
[L.ind,L.nN,L.dimN,L.xscal,L.resscal,L.LX2x,L.isEvolutive,L.nuN,L.nrD] = meqalgoNLc(L,P.algoNL,true);

%% Define matrices for temporal evolution problem
Mya = G.Mxa(L.lxy(:),:); % Mutual between internal grid and active coils
Myu = G.Mxu(L.lxy(:),:); % Mutual between internal grid and vessel segments

L.Mey = P.mey*[Mya.' ; Myu.']; % Mutual between external currents and plasma current

L.Mee = [G.Maa , G.Mau; G.Mau.', G.Muu]; % Mutual inductance between external currents
L.Re  = [G.Ra;G.Ru]; % Resistance of external currents

%% Coils for providing inductive voltage or compensation field
assert(~iscell(P.ohcoils)   || ~isempty(P.ohcoils)  ,  'ohcoils can not be an empty cell array')
assert(~iscell(P.compcoils) || ~isempty(P.compcoils),'compcoils can not be an empty cell array')
L.ioha   = contains(G.dima,P.ohcoils);
L.icompa = contains(G.dima,P.compcoils);

%% Additional derivative functions
% OhmTor_rigid_0D needs Mye and Myy
if L.np && strcmp(P.cde,'OhmTor_rigid_0D')
  if L.nD == 1
    % OhmTor_rigid_0D needs Mye for single domains ...
    if P.anajac
      L.Mye = L.Mxe(L.lxy,:);
    else
      L.Mye = [G.Mxa(L.lxy,:),G.Mxu(L.lxy,:)];
    end
  else
    % ... or Myy for multiple domains
    if P.anajac
      L.Myy = L.Mxy(L.lxy,:);
    else
      L.Myy = G.Mxx(L.lxy,L.lxy);
    end
  end
end
  
%% Linear part of jacobians
if P.anajac
  [L.Jx,L.Ju,L.Jxdot] = fgeFvacJac(L);
end

end
