function dIacomp = fgeIacomp(L,dIe)
% Compute currents in compensating field coils
% to compensate for a change in Ie currents while maintaing equilibrium.
% This amounts to generating zero flux by the combination of dIe and the
% to-be-determined Icomp currents
%
% Solve LSQ problem: min || Ox.*Mxa(:,icomp) * dIacomp + Ox.*Mxa*dIe ||
% where dIacomp is nonzero only for the compensation coil set P.compa.
% Ox defines the region of interest.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

Ox = L.Oasx(:); Ox = Ox/sum(Ox(:));

A =  Ox.* L.G.Mxa(:,L.icompa);
b = -Ox.*[L.G.Mxa,L.G.Mxu]*dIe;
dIco = A\b;

dIacomp = zeros(L.G.na,1);
dIacomp(L.icompa) = dIco;
end