function LX = fbtxcat(LX,varargin)
%FBTXCAT Concatenate FBT LX structures
% 
% Calls meqcat and then fixes NaNs in gp*e, gp*d terms
% See also MEQCAT
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

for ii=1:numel(varargin)
  LXs = varargin{ii};
  % add empty missing fields if any
  for field = setdiff(fieldnames(LX),fieldnames(LXs))'
    LXs.(field{:}) = [];
  end
  for field = setdiff(fieldnames(LXs),fieldnames(LX))'
    LX.(field{:}) = [];
  end
  % cat to LX
  LX = meqcat(LX,LXs);
end

% fix e,d fields
% fix gpb field
for field = fieldnames(LX)'
  fld = field{1};
  if strcmp(fld([1,end]),'gb') %g?b
    LX.(fld)(isnan(LX.(fld))) = false; 
  end
  if any(endsWith(fld,{'e','d'}))
    LX.(fld)(isnan(LX.(fld))) = Inf;
  end
end


end
