function varargout=fbtplot(L,LX,LY,varargin)
% fbtplot(L,LX,LY)
%
% Plotting for FBT
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

ii = find(contains(varargin(1:2:end),'parent'));
if ~isempty(ii)
  ax=varargin{2*ii}; 
  ikeep = true(size(varargin)); ikeep(2*ii+[-1,0]) = false;
  varargin = varargin(ikeep);
else
  ax = gca;
end

if L.P.izgrid
  hax = meqplotfancy(L,LY,'fillPlasma',false,'parent',ax);
else
  hax = meqplott(L,LY,'parent',ax); 
end
hold(hax,'on');
% plot one contour on FBT flux offset value from optimizer
contour(hax,L.rx,L.zx,LY.Fx,LY.Fb*[1 1],'b--','linewidth',2)
fbtxplot(L,LX,'parent',hax,varargin{:});
if nargout>0
  varargout{1}=hax;
end
end