function [Raxc,Rauc,Rabc,Ra0c,Rexc,Reuc,Rebc,Re0c,Rixc,Riuc,Ribc,Ri0c, ...
  IDs,ws,bbs,TusU,TFbsU,d1dt,d2dt] = fbtlsqinit(L,LXs)
% FBTLSQINIT assembles all FBT optimization problem for given time interval
%
% [Raxc,Rauc,Rabc,Rac,Rexc,Reuc,Rebc,Rec,Rixc,Riuc,Ribc,Ric,IDs,ws,bbs] ...
%   = fbtlsqinit(L,LXs)
% 
% Inputs: L,LXs: FBT L, and (possibly multi-slice) LX structures
% Outputs:
% * cell arrays Raxc,Rauc,Rabc,Rac,Rexc,Reuc,Rebc,Rec,Rixc,Riuc,Ribc,Ric
%   with optimization problem matrices for each time (c stands for cell,
%   see FBTOPT for details about the R?? notation)
% * IDs, ws, bbs: cell arrays of ID, w, bb (see FBTOPT for details)
% * TusU,TFbsU: Transfer matrices between us, Fbs and U
% * d1dt,d2dt: Stencils for 1st and 2nd order time derivatives
%
% SEE ALSO FBTHELP, MEQLSQPREP, MEQLSQSOLVE, FBTOPT, FBTT
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Setup terms for FBT optimization problem.
% Get fbtopt for multiple slices into cell arrays

nt = numel(LXs.t);
na = L.G.na;

% init

if any(startsWith(fieldnames(LXs),'g2')), max_derorder = 2;
elseif any(startsWith(fieldnames(LXs),'g1')), max_derorder = 1;
else, max_derorder = 0;
end

c = cell(max_derorder+1,nt);
Raxc=c;Rauc=c;Rabc=c;Ra0c=c;
Rexc=c;Reuc=c;Rebc=c;Re0c=c;
Rixc=c;Riuc=c;Ribc=c;Ri0c=c;
IDs=c;ws=c;bbs=c;
c = cell(1,nt);
TusU=c;TFbsU=c;

nU = (na+1)*nt;
eyeU = eye(nU);

% Stencils for 1st and 2nd order time derivatives
%  d fdt (t=t(i)) = sum(d1dt(i,j)*f(t=t(j)))
%  d2fdt2(t=t(i)) = sum(d12t(i,j)*f(t=t(j)))
[d1dt,d2dt] = fbttimeder(LXs.t,L.P.timeder);

for it = 1:nt
  LXt = meqxk(LXs,it);
  for derorder = 0:max_derorder
    GPt = fbtLX2GP(LXt,derorder);
    idoublet = LXt.idoublet;
    id = derorder + 1;
    % Run fbtopt for each slice and each derivative order
    [Raxc{id,it},Rauc{id,it},Rabc{id,it},Ra0c{id,it},...
     Rexc{id,it},Reuc{id,it},Rebc{id,it},Re0c{id,it},...
     Rixc{id,it},Riuc{id,it},Ribc{id,it},Ri0c{id,it},...
     IDs{id,it},ws{id,it},bbs{id,it}] = fbtopt(L,GPt,idoublet);
  end
  
  % Transfer matrix between us{it} and U
  TusU{it} = eyeU((it-1)*na+1:na*it,:);
  % Transfer matrix between Fbs{it} and U
  TFbsU{it} = eyeU(na*nt+it,:);
end
