% FBTHELP - Help for FBT
%
% FBT by default solves the inverse static problem:
% * Given: 
%   * Cost function weights and constraints on flux, field, currents
%   * Internal plasma constraints (e.g. bp, Ip, qA)
%   * Inequality constraints on (combinations of) Ia.
% * Finds: 
%   * Ia and corresponding Equilibrium minimizing cost function while
%     satisfying constraints.
%   * If P.circuit = true, additionally solves for Iu and Va satisfying 
%     the time-dependent circuit equations including the plasma.
%
% Setup of the constrained optimization problem: 
% The fitting parameters on the left hand side are Ia and Fb (coil currents
% and an offset flux).
%
% On the right side are the user-prescribed values and the plasma contribution Iy
% The latter is iterated as it depends on Ie.
%
% Each constraint group has a global absolute error gp?d (a scalar) and a
% relative error gp?e (a vector with as many elements as elements in the
% group), such that the expected error for each element is gp?d*gp?e.
%
% equals(=) sign means equality constraint if the expected error is 0
% (weight is infinity). Otherwise the equation is solved with the others in
% the least-squares sense.
%
% 1./(gpid*gpie) * [ Ia                    = gpia                          ]  % ID=1  Active (coil) currents
% 1./(gpod*gpoe) * [ Coa*Ia                = gpco                          ]  % ID=1  Active (coil) constraints
% 1./(gpdd*gpde) * [ Dda*(gpdw.*Ia)        = gpda                          ]  % ID=2  Dipoles
% 1./(gpud*gpue) * [ Iu                    = gpua                          ]  % ID=3  Passive currents
% 1./(gpfd*gpfe) * [ MSe*Ie   - gpfb*Fb    = gpfa  - MSy*Iy                ]  % ID=4  Flux
% 1./(gpbd*gpbe) * [ BrSe*Ie               = gpbr  - BrSy*Iy               ]  % ID=5  Br
% 1./(gpbd*gpbe) * [ BzSe*Ie               = gpbz  - BzSy*Iy               ]  % ID=5  Bz
% 1./(gpbd*gpbe) * [ Gba*[BrSe;BzSe]*Ie    = 0     - Gba*[BrSy;BzSy]*Iy    ]  % ID=5  Field angle
% 1./(gpcd*gpce) * [ MrrSe*Ie              = gpcr  - MrrSy*Iy              ]  % ID=6  Frr constraint 
% 1./(gpcd*gpce) * [ MrzSe*Ie              = gpcz  - MrzSy*Iy              ]  % ID=6  Frz constraint 
% 1./(gpcd*gpca) * [ Gca*[MrrSe;MrzSe]*Ie  = 0     - Gca*[MrrSy;MrzSy]*Iy  ]  % ID=6  Hessian angle
% 1./(gpvd*gpve) * [ BrrSe*Ie              = gpvrr                         ]  % ID=7  Vacuum Brr constraint 
% 1./(gpcd*gpve) * [ BrzSe*Ie              = gpvrz                         ]  % ID=7  Vacuum Brz constraint 
% 1./(gpcd*gpve) * [ BzzSe*Ie              = gpvzz                         ]  % ID=7  Vacuum Bzz constraint 
% 1./(gpad*gpae) * [ Va                    = gpaa                          ]  % ID=8  Active coil voltage 
%
% Ie is the vector of conductor currents [Ia;Iu] and M??Se, B??Se matrices 
% are Green's functions linking these currents to flux/field values on the control points.
%
% Control point constraints gpf* gpb* gpc* gpv* as well as locations gpr, gpz 
% can be supplied using FBTGP(). See FBTGP for details on the syntax
%
% Dda Matrix such that Dda*Ia gives current differences e.g. [Ia(2)-Ia(1);...;Ia(na)-Ia(na-1)];
% Gba = [sin(gpba),-cos(gpba)];
% Gca = [sin(gpca),-cos(gpca)];
%
% Dda is contained in G, while all other matrices are calculated in each time loop by fbtt.m
%
% If one of the Br/Bz or Mrr,Mrz components are constrained, then 
% the corresponding angle constraint is automatically ignored.
%
% Passive current (Iu) model:
%   If P.circuit = false, then Iu is assumed to be known
%   It can be prescribed via LX.gpua (time-dependent)
%   In this case, the corresponding M?Su*Iu, B?Su*Iu terms go to the
%   right-hand side
%
%   If P.circuit = true, Iu is solved-self-consistently following the
%   circuit equation
%     Mee*Iedot + Re*Iu + Mey*Iydot = [Va;0]
%    
% NOTE: Fb and FB (boundary flux) are not necessarily the same, unless the
% solution has LCFS passing through a point with gpfb=1 and gpfa=0 and gpfe*gpfd=0.
%
% Inequality constraints:
% liml*limm < limc*Ia < limu*limm
% limm is a margin, limu,liml are upper/lower bounds, limc is a matrix.
% All are contained in P
%
% See also: FBT, FBTT, FBTGP, FBTX
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

