%FBTGTCV  TCV FBT geometry and electromagnetic parameters
% FBTGTCV(SHOT,P) returns a structure with geometry and electromagnetic
% parameters for TCV SHOT. See also MEQGTCV,FBTG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function G = fbtgtcv(shot,P)

 sell = [];
 
 P.shot = shot;
 xargs = {'Ra'};
 if P.circuit
   assert(~isequal(P.selu,'n'),'FBT TCV circuit with selu=n not supported yet');
   xargs = [xargs,{'Muu','Mau'}];
 end
 G = meqgtcv(P,P.sela,38,sell,1:38,1:38,P.selx,P.selu,P.selc,xargs{:});
 
 % Extra constraints on coil currents
 if P.dohzero && any(contains(P.sela,'OH'))
   % constrain IOH1=IOH2
   iOH = contains(G.dima,'OH');  
   DOH = zeros(1,numel(G.dima)); DOH(iOH) = [1 -1];
   G.Coa = DOH;
   G.no = size(G.Coa,1);
 else
   G.Coa = zeros(0,numel(G.dima));
   G.no  = 0;
 end
end
