function LX = fbtgpclear(LX)
% Clear control points from FBT LX structure
% Replaces control point fields usually set by fbtgp by empty fields with
% second dimension matching number of time points
%
% See also FBTGP
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if nargin==0
  LX = struct();
  return
end

nt = numel(LX.t);
for derorder = 0:2
  switch derorder
    case 0, gp='gp';
    case 1, gp='g1';
    case 2, gp='g2';
  end
  
  for flds = {'r','z','b',...
      'fa','fb','fe',...
      'br','bz','ba','be',...
      'cr','cz','ca','ce',...
      'vrr','vrz','vzz','ve'}
    field = [gp,flds{:}];
    if isfield(LX,field)
      LX.(field) = zeros(0,nt);
    end
  end
end
end