%FBTG  FBTE geometry and electromagnetic parameters
% G = FBTG(G,P) defines missing fields in the structure G using parameters
% in structure P. See also MEQG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function G = fbtg(G,P,xargs)

if nargin<3, xargs={}; end

if P.circuit
   xargs = [xargs,{'Maa','Ra','Mau','Muu','Ru'}];
end

G = meqg(G,P,xargs{:});

% defaults for Ia linear constraints
if ~isfield(G,'Coa')
  G.Coa = zeros(0,G.na);
end
if ~isfield(G,'no')
  G.no = size(G.Coa,1);
end

end
