%FBTE  TCV FBTE equilibrium calculation
% [L,LX,LY] = FBTE(SHOT,'PAR',VAL,...) calls FBT('TCV',SHOT,...) and writes
% results in PCS tree. See also FBT.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = fbte(shot,varargin)
 
 [varargout{1:nargout}] = fbt('TCV',shot,[],'LYall',true,varargin{:});
 if nargout > 2 && (shot == -1 || (shot >= 9e5 && shot <1e6))
  L  = varargout{1};
  LY = varargout{3};
  psiwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY)
  meqwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY)
  fbtwtcv(shot,'PCS','\TOP'            ,L,LY) % old style nodes
  % codwtcv(shot,'PCS',,'FBTE.M','Standard FBTE.M run') % No nodes yet for this
 end
 
end
