function GP=fbtLX2GP(LX,derorder)
% Helper function to get GP (FBT constraint variables) for a given order
% from an FBT LX structure.
%
% See MEQLSQPREP, FBTOPT
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

switch derorder
  case 0, gp = 'gp';
  otherwise, gp = ['g',num2str(derorder)];
end
% find LX fields matching pattern
LXfields = fieldnames(LX)';
GPfields = LXfields(startsWith(LXfields,gp));
GP = struct();

if isempty(GPfields) % no fields
  return
end

for gnfld=GPfields
  % convert g1*,g2* to gp* equivalent
  gpfld = ['gp',gnfld{:}(3:end)];
  GP.(gpfld) = LX.(gnfld{:});
end

% also add time
GP.t = LX.t;
end
