%FBNDMEX  Find LCFS
% [FB,RB,ZB,LB,LX,kB] = FBNDMEX(FL,RL,ZL,FX,RX,ZX,FN) finds the flux FB and
% the limiting point (RB,ZB) of the LCFS. FL is the flux on the limiter
% points (RL,ZL), FX the flux of the X-points (RX,ZX). FN, e.g. -Inf*Ip,
% flags in FL and FX non valid entries. For Ip>0, FN<0, FB = max([FL FX]),
% for Ip<0, FN>0, FB = min([FL FX]). LB is FALSE if no valid point is
% found. LX is TRUE if an X-point defines the LCFS. KB is the index of the
% active X-point if LX is true or of the limiter point otherwise.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = fbndmex(varargin) %#ok<STOUT>
 error('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
end
