# MEQ Geometry cheatsheet
This cheatsheet provides help to beginner users trying to understand MEQ `G` (geometry) structure variable naming. In general, naming follows a strict convention that is explained in `meqhelp.m`. For output quantities, see `meqt.m` Also please consult the [README.md](../README.md) file for more help sources.
See also `meqg.m`, `vveig.m`

Quantities are part of the `L.G` structure unless specified otherwise. 


## Computational grids  
| Variable name | Description |
| ----------- | ----------- |
| `LY.Fx` | flux on the `x` grid   |
| `LY.Brx`| Radial magnetic field on the `x` grid |
| `LY.Bzx`| Verical magnetic field on the `x` grid |
| `LY.Iy` | plasma current on `y` grid  |
| `rx`    | r coordinate of `x` grid (computational grid inside limiter) |
| `zx`    | z coordinate of `x` grid (computational grid inside limiter) |
| `L.nzx` | number of `zx` elements |
| `L.nrx` | number of `rx` elements |
| `L.rrx` | r of meshgrid for `rx,zx` |
| `L.zzx` | z of meshgrid for `rx,zx` |
| `rz`    | r coordinate of `z` grid (extended outside limiter for post-processing) |
| `zz`    | z coordinate of `z` grid (extended outside limiter for post-processing) |
| `ry`    | reduced grid for plasma current: `rx(2:end-1)` |
| `zy`    | reduced grid for plasma current: `zx(2:end-1)` |
| `Mxx`   | mutual indutance between filaments on plasma `x` grid |

## Magnetic probes
| Variable name | Description |
| ----------- | ----------- |
| `rm`  | r position of magnetic field measurement point |
| `zm`  | z position of magnetic field measurement point |
| `am`  | orientation (in rad), positive counterlockwise so that `Bm = cos(am)*Br + sin(am)*Bz` |
| `Tmm` | Matrix to compose effective probe measurements as linear combinations of ideal ones. |
| `Bma` | transfer function that gives measured B fields at mag. probes due to currents in active coils `Bm = Bma*Ia` |
| `Bmx` | same as `Bma` but for `Ix` currents in the plasma grid |
| `Bmu` | same as `Bma` but for `Iu` passive currents |
| `dimm` | description string   |
| `nm` | number of probes   |

 
## Flux loops  
| Variable name | Description |
| ----------- | ----------- |
| `rf`   | r position of flux loops       |
| `zf`   | z position of flux loops          |
| `Tff`  | Matrix to compose effective flux measurements as linear combinations of ideal ones. |
| `Mfa`  | mutual inductance between flux loops and active coils (`Mfa*Ia` is flux measured at each loop due to current) |
| `Mfv`  | mutual inductance between flux loops and filamentary vessel |
| `Mfu`  | mutual inductance between flux loops and generalized vessel  |
| `Mfx`  | mutual inductance between flux loops and plasma current elements |
| `dimf` | flux loop labels   |
| `nf`   | number of flux loops   |

## Active circuits  
| Variable name | Description |
| ----------- | ----------- |
| `LY.Ia` | active coil currents   |
| `Maa`   | mutual inductance between active circuits |
| `Mav`   | mutual inductance between active circuits and vessel filament elements |
| `Mau`   | mutual inductance between active circuits and generalized vessel |
| `Mxa`   | mutual inductance between `x` grid and active circuits |
| `Mza`   | mutual inductance between `z` grid and active circuits |
| `Brxa`  | matrix such that `Br = Brxa*Ia`. Where `Br` is the radial magnetic field on the `x` grid due to currents in the active circuits |
| `Bzxa`  | Same as `Brxa` but for vertical component of poloidal field |
| `dima`  | active coil labels  |
| `na`    | number of active circuits   |
   
## Vessel filamentary description 
| Variable name | Description |
| ----------- | ----------- |
| `LY.Iv` | Vessel filament currents 
| `Mvv`   | mutual inductance between vessel filaments
| `Rv`    | resistance of individual vessel elements
| `rv`    | `r` location of filament  
| `zv`    | `z` location of filament  
| `hv`    | height of rectangular filament (`dv=NaN`)
| `wv`    | width of rectangular filament (`dv=NaN`)
| `dv`    | diameter of circular filament (`wv=hv=NaN`)
| `dimv`  |description label  

## Vessel filamentary description 
| Variable name | Description |
| ----------- | ----------- |
| `LY.Iv` | Vessel filament currents |
| `Mvv`   | mutual inductance between vessel filaments |
| `Rv`    | resistance of individual vessel elements |
| `rv`    | `r` location of filament   |
| `zv`    | `z` location of filament   |
| `hv`    | height of rectangular filament (`dv=NaN`) |
| `wv`    | width of rectangular filament (`dv=NaN`) |
| `dv`    | diameter of circular filament (`wv=hv=NaN`) |
| `dimv`  | description label   |

## Generalized vessel   
| Variable name | Description |
| ----------- | ----------- |
| `LY.Iu` | generalized vessel currents |
| `Tvu`   | matrix such that `Iv=Tvu*Iu` |
| `Tuv`   | matrix premultiplying vessel current equation such that `Muu=Tuv*Mvv*Tvu` (see `vveig.m`) |
| `Mxu`   | mutual inductance between `x` grid and vessel currents |
| `Mzu`   | mutual inductance between `z` grid and vessel currents |
| `Muu`   | mutual inductances for generalized passive currents |
| `Mau`   | mutual inductances between generalized passive currents and active coil currents |
| `Brxu`  | matrix such that `Br = Brxu*Iu`. Where `Br` is the radial magnetic  field on the `x` grid due to currents in the vessel currents |
| `Bzxu`  | same as `Brxu` but for vertical component of poloidal field |
| `Brzu`  | matrix such that `Br = Brzu*Iu`. Where `Br` is the radial magnetic  field on the `z` grid due to currents in the vessel currents |
| `Bzzu`  | same as `Bzzu` but for the vertical component of the poloidal field |
| `Ru`    | resistances for generalized vessel description |
| `dimu`  | description label |
