function dispparams(P)
% Helper function to display parameter structures
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

for field = fieldnames(P)'
  val = P.(field{:});
  % remove large numeric fields since these are not well displayed by
  % disp() in octave
  if isnumeric(val) && numel(val)>10
    P = rmfield(P,field{:});
    fprintf('%19s: size = %s, class = %s\n',field{:},mat2str(size(val)),class(val));
  end
end
% then display what is left
disp(P);
end