%CODWTCV  Writes Code details in TCV tree
% CODWTCV(SHOT,TREE,BRANCH,CODENAME,COMMENT) writes the
% code details in the BRANCH of TREE for SHOT.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function codwtcv(shot,tree,branch,codename,comment)
 
 [~,code] = meqver;

 %% Code
 meqmdsopen(shot,tree,branch)
 meqput('NAME'      ,codename   ,'t',{                         },'','Name of the code that produced the results'                 );
 meqput('COMMIT'    ,code.commit,'t',{{'meq','genlib','psitbx'}},'','Unique commit reference of the code and of its dependencies');
 meqput('VERSION'   ,code.tag   ,'t',{{'meq','genlib','psitbx'}},'','Unique version of the code (tag) and of its dependencies'   );
 meqput('REPOSITORY',code.url   ,'t',{{'meq','genlib','psitbx'}},'','URL of the code repository and of its dependencies'         );
 meqput('COMMENT'   ,comment    ,'t',{                         },'','Description of the run'                                     );
 
end
