%CIZRMEX  Compute custom cross-section integrals
% [IVQ] = CIZRMEX(FX,OPY,VY,DSX,FNQ,F0,F1);
% Computes cross-section integrals on plasma grid from
% Inputs:
%  FX:  F(z,r) plasma flux
%  OPY: Plasma domain mapping
%  VY:  Values of custom function of Y grid (size: [ny,nV])
%  RBT: vacuum R*BT
%  DSX: RZ grid cell area
%  FNQ: Normalised flux on Q grid
%  F0, F1: limiting flux values for each domain
% Outputs:
%  (all as functions of Q grid and domain)
%  IVQ: Integrals of V functions (size: [nQ,nD,nV])
%
% Examples:
%  VpQD = VIZRMEX(Fx,Opy,2*pi*L.rry(:),dsx,FNQ,F0,F1);
%    VpQD(iQ,iD) is the volume enclosed by the flux surface 
%    corresponding to FN<=FNQ(iQ) for the domain iD.
%
% For details, see: [MEQ-redbook]
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = cizrmex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = cizrmexm(varargin{:});
end
