%BSLVMEX  Block solving algorithm
% [a,b] = BSLVMEX(a1,b1,b0,A,B,NI) solves the system
% [a;b]=[a1;b1]-[A,B]*[a;b] by setting b=b0 and running NI iterations
% a=a1-A*b, b=b1-B*a.
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015], Section 4.4 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [a,b] = bslvmex(a1,b1,b0,A,B,ni)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 b = b0;
 for k = 1:ni
  a = a1 - A*b;
  b = b1 - B*a;
 end
end