function P = bfpdoublet(Pu)
% BFPDOUBLET Consolidates bfdoublet parameter structure from user input
%
%   P = BFPGEND(PU)
%
% PU are the user-defined parameters for BFDOUBLET (see BFDOUBLET help for
% a description of the syntax).
%
% See also: BFDOUBLET
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Run checks
Pu = bfpck(@bfdoublet,Pu);

% Return if parameters are already consolidated
if isstruct(Pu)
  P = Pu;
  return;
end

% get info on third basis function set
bfct3 = Pu{3,1}; bfp3 = Pu{3,2};
[fPg3,~] = bfct3(0, bfp3);
% build useful index sets
ngl = numel(Pu{1,1}(0, Pu{1,2})) + numel(Pu{2,1}(0, Pu{2,2}));
ngm = numel(fPg3);
igm = ngl+(1:ngm);
  
% this function wraps bfgenD and adds the trivially continued part of the
% mantle basis functions externally
PbfgenD = bfpgenD({Pu{1,1}  , Pu{1,2}, [1;0;0]; ...
                   Pu{2,1}  , Pu{2,2}, [0;1;0]; ...
                   Pu{3,1}  , Pu{3,2}, [0;0;1]},3);

[fPg,fTg,TDg] = bfgenD(0,PbfgenD);
TDg(:,igm) = true; % mantle degrees of freedom extended to lobes

% Assemble
P.PbfgenD = PbfgenD;
P.igm = igm;
P.fPg = fPg;
P.fTg = fTg;
P.TDg = TDg;

end
