function bfp = bfpck(bfname,bfp,nD)
%BFPCK  Check bf parameter validity and assign default values
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

msgid = 'MEQ:ParameterError';

if isa(bfname,'function_handle')
  bfname = func2str(bfname);
end

switch bfname
  case 'bfabmex'
    if isempty(bfp), bfp = [1 2]; % default for this bf if not defined
    else,  assert(numel(bfp)==2 && isnumeric(bfp),msgid,'bfp should be a vector with 2 elements for bfct=@bfabmex');
    end
    assert(bfp(1) <= 3,msgid,'BFCT=BFAB and BFP(1)=%g',bfp(1))
    assert(bfp(2) <= 3,msgid,'BFCT=BFAB and BFP(2)=%g',bfp(2))
  case 'bfefmex'
    if isempty(bfp), bfp = [1 2]; % default for this bf if not defined
    else, assert(numel(bfp)==2 && isnumeric(bfp),msgid,'bfp should be a vector with 2 elements for bfct=@bfefmex');
    end
    assert(bfp(1) <= 4,msgid,'BFCT=BFEF and BFP(1)=%g',bfp(1))
    assert(bfp(2) <= 4,msgid,'BFCT=BFEF and BFP(2)=%g',bfp(2))
  case 'bf3pmex'
    if isempty(bfp)||isequal(bfp,0), bfp = false; % default for this bf if not defined or user sets 0
    else, assert(islogical(bfp) && isscalar(bfp),msgid,'bfp must be scalar logical for bfct=@bf3pmex')
    end
  case 'bffbt'
    assert(size(bfp,1)==6 && isnumeric(bfp),msgid,'bfp should be a vector with 6 elements for bfct=@bffbt')
    % Check that exponents are positive
    assert(all(bfp(3,:) >= 0),msgid,'BFCT=BFFBT and BFP(3)<0')
    assert(all(bfp(6,:) >= 0),msgid,'BFCT=BFFBT and BFP(6)<0')
  case {'bfgenD','bfdoublet'}
    isbfgenD = strcmp(bfname,'bfgenD');
    % Pass if parameters have already been consolidated
    if isstruct(bfp), return; end
    % Check type and size
    if isbfgenD
      ncol = 3;
    else
      ncol = 2;
    end
    assert(iscell(bfp) && size(bfp,2) == ncol,'If bfct=@%s bfp should be a cell array with %d columns',bfname,ncol)
    % Check individual function handles
    assert(all(cellfun(@(x) isa(x,'function_handle') ,bfp(:,1),'UniformOutput',true)),...
      msgid,'If bfct=@bfgenD all elements in the first column of bfp must be function handles');
    % Check individual parameters
    for ii = 1:size(bfp,1)
      bfp{ii,2} = bfpck(func2str(bfp{ii,1}),bfp{ii,2},1);
    end
    if isbfgenD
      % Check domain assignment vectors
      assert(all(cellfun(@(x) isequal(size(x),[nD,1]),bfp(:,3),'UniformOutput',true)),...
        msgid,'If bfct=@bfgenD all elements in the third column of bfp must be vectors of size [nD,1]');
    end
end
end