%ASXYMEX  Localise extrema and saddle points of a 2D-map
% [XA,YA,FA,DX2FA,DY2FA,DXYFA,IXA,XS,YS,FS,DX2FS,DY2FS,DXYFS,IXS,STAT] =
% ASXYMEX(F,X,Y,DC,DX,DY,IDX,IDY,L,DIMW) takes a 2D-map F(X,Y) and returns
% the location and value XA,YA,FA and XS,YS,FS of its extrema and saddle
% points, as well as the 2nd derivatives at those points and the index of
% the cell centers from which these were interpolated. Extremum/saddle
% pairs whose normalised distance (dx/DX)^2+(dy/DY)^2 < DC are cancelled.
% The non empty boolean matrix L(X,Y) limits the search where
% TRUE. DX=X(2)-X(1),IDX=1/DX,DY=Y(2)-Y(1),IDY=1/DY. The integer DIMW
% limits the search to DIMW extrema or saddle points. If that number is
% exceeded, STAT=0 and 1 otherwise.
%
% For details, see: [J-M. Moret et al. Fus.Eng.Des 2015] and [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = asxymex(varargin) %#ok<STOUT>
 error('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
end
