function bool = startsWith(str,pattern)
% STARTSWITH True if text starts with pattern
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

  if ~iscell(str), str = {str}; end
  if ~iscell(pattern), pattern = {pattern}; end

  bool = false(size(str));
  for ii = 1:numel(pattern)
    bool = bool | strncmp(str,pattern{ii},length(pattern{ii}));
  end
end
