function str = getReport(ME)
% GETREPORT Get error message for exception
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

  % This is not the same as the MATLAB format
  if isempty(ME.stack)
    str = ME.message;
  else
    istack = ME.stack(1);
    str = sprintf('Error using %s (file: %s, line %d):\n%s',...
            istack.name,istack.file,istack.line,ME.message);
    if numel(ME.stack)>1
      str = [str,newline];
      for ii = 2:numel(ME.stack)
        istack = ME.stack(ii);
        str = [str,sprintf('\nError in %s (file: %s, line %d)',...
                     istack.name, istack.file, istack.line)];
      end
    end
  end

end
