function SCdisp(SC)
% Display shape control struct
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% Parse inputs
p = inputParser;
% Validation functions
checkSC = @(SC) isstruct(SC);
% Add inputs
addRequired(p,'SC',checkSC);
% Get parser results
parse(p,SC);
% Sanity check
assert(numel(SC.t)==1,'supported for 1 timeslice only, use meqxk() to slice')

%% Dispay control points infos
fprintf('\n           lsC, lsL, lsS, lsX1, lsX2, lsD, lsI,      R,      Z\n');
for ic = 1:SC.nc
  fprintf('%02d %s:   %d,   %d,   %d,    %d,    %d,   %d,   %d, %+2.3f, %+2.3f\n',...
    ic, SC.dimc{ic},SC.lcC(ic),SC.lcL(ic),SC.lcS(ic),SC.lcX1(ic),SC.lcX2(ic),...
    SC.lcD(ic),SC.lcI(ic),SC.rc(ic),SC.zc(ic));
end

end
