function Co = LX2Co(L,LX)
% Extract and pack Co from LX structure. 
% Co contains all fields listed in L.agconc
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

Co = zeros(L.nC,numel(LX.t)); 
for iC=1:L.nC
  ii = L.agconc{iC,4};
  field = L.agconc{iC,3}; % field and index for this constraint
  if strcmp(field,'fbtlegacy'), continue; end % Skip constraints without LX field
  assert(isfield(LX,field), 'Request constraint %s not available in input LX structure', field);
  Co(iC,:) = LX.(field)(ii,:);
end
end