function G = pf_passive2G(G, pf_passive, P)
%PF_PASSIVE2G Complement G structure with information from pf_passive IDS
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

[rv,zv,hv,wv,Rv] = deal([]);
for ii=1:numel(pf_passive.loop) % iterate over loops
  [ri,zi,ro,zo] = deal([]);
  for jj=1:numel(pf_passive.loop{ii}.element) % iterate over elements
    switch pf_passive.loop{ii}.element{jj}.geometry.geometry_type
      case 1 % outline
        rl = pf_passive.loop{ii}.element{jj}.geometry.outline.r;
        zl = pf_passive.loop{ii}.element{jj}.geometry.outline.z;
        resistivity = pf_passive.loop{ii}.resistivity;
        
        [ri_tmp,zi_tmp,ro_tmp,zo_tmp] = outline2innerouterlines(rl,zl,P.rayr0,P.rayz0,P);
        % Accomulate inner/outer line for 1 loop
        ri = [ri;ri_tmp]; zi = [zi;zi_tmp];
        ro = [ro;ro_tmp]; zo = [zo;zo_tmp];

        % Create filaments from inner and outer line.
        [rv_tmp,zv_tmp, hv_tmp, wv_tmp, Rv_tmp] = patch_inner_outer(ri,zi,ro,zo,P.rayr0,P.rayz0,resistivity,P);
            
      case 3 % oblique
        % Potentially every element could have a different geometry.
        % Hence, it needs to be accumulated dynamically.
        pfrzdrdz = zeros(6,1);
        pfrzdrdz(1) = pf_passive.loop{ii}.element{jj}.geometry.oblique.r;
        pfrzdrdz(2) = pf_passive.loop{ii}.element{jj}.geometry.oblique.z;
        pfrzdrdz(3) = pf_passive.loop{ii}.element{jj}.geometry.oblique.length_alpha;
        pfrzdrdz(4) = pf_passive.loop{ii}.element{jj}.geometry.oblique.length_beta;
        pfrzdrdz(5) = pf_passive.loop{ii}.element{jj}.geometry.oblique.alpha;
        pfrzdrdz(6) = pf_passive.loop{ii}.element{jj}.geometry.oblique.beta;
        
        turns_with_sign =  pf_passive.loop{ii}.element{jj}.turns_with_sign;
        [rv_tmp, zv_tmp, av_tmp, wv_tmp, hv_tmp] = gen_filament(pfrzdrdz, turns_with_sign, 3);
        Rv_tmp = 2*pi*pf_passive.loop{ii}.resistivity*rv_tmp./av_tmp;

      otherwise
        error('Not yet implemented')
    end
    
    rv = [rv; rv_tmp]; zv = [zv; zv_tmp];
    hv = [hv; hv_tmp]; wv = [wv; wv_tmp];
    Rv = [Rv; Rv_tmp];

  end
end

% Initialise or extend the fields.
% Some passive filaments could have already been populated from ids.wall.
if ~isfield(G,'rv'), G.rv = rv; else, G.rv = [G.rv; rv]; end
if ~isfield(G,'zv'), G.zv = zv; else, G.zv = [G.zv; zv]; end
if ~isfield(G,'hv'), G.hv = hv; else, G.hv = [G.hv; hv]; end
if ~isfield(G,'wv'), G.wv = wv; else, G.wv = [G.wv; wv]; end
if ~isfield(G,'Rv'), G.Rv = Rv; else, G.Rv = [G.Rv; Rv]; end

G.nv = numel(G.rv);
% TODO. Passive structure could be grouped into different elements. Not yet implemented.
G.Tivs = ones(G.nv);
G.Rs = G.Rv;

end