function G = magnetics2G(G, magnetics, P)
%MAGNETICS2G Extract G from ids.magnetics
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Ovewrite default
D = struct;
D.debug = 0;
D.debugplot = 0;
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

%% Flux loops
G.nf = numel(magnetics.flux_loop);
G.dimf = cell(G.nf,1); G.rf = zeros(G.nf,1); G.zf = zeros(G.nf,1);
for ii=1:G.nf
  G.dimf{ii} = magnetics.flux_loop{ii}.name;
  G.rf(ii) = magnetics.flux_loop{ii}.position{1}.r;
  G.zf(ii) = magnetics.flux_loop{ii}.position{1}.z;
end

%% Poloidal magnetic probes
G.nm = numel(magnetics.b_field_pol_probe);
G.dimm = cell(G.nm,1); G.rm = zeros(G.nm,1);
G.zm = zeros(G.nm,1); G.am = zeros(G.nm,1);
for ii=1:G.nm
  G.dimm{ii} =  magnetics.b_field_pol_probe{ii}.name;
  G.rm(ii) = magnetics.b_field_pol_probe{ii}.position.r;
  G.zm(ii) = magnetics.b_field_pol_probe{ii}.position.z;
  % MEQ conventions assume a counter-clockwise orientation in RZ plane for am, COCOS11 defines a clockwise poloidal angle
  G.am(ii) = -magnetics.b_field_pol_probe{ii}.poloidal_angle;
end


end