function LX = Co2LX(L,LX,Co)
% CO2LX Update LX with values from constraints vector Co 
% Co contains all fields listed in L.agconc
% This is the inverse process of LX2Co
%
% See also LX2CO
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Update LX
for iC = 1:L.nC
  field = L.agconc{iC,3};
  index = L.agconc{iC,4};
  if strcmp(field,'fbtlegacy'), continue; end % Skip constraints without LX field
  val = LX.(field);
  val(index) = Co(iC);
  LX.(field) = val;
end
end
