# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## Unreleased

- !961: Add Apache 2.0 license, update genlib to 3.10.0
- !960: Add MEQGUI with clickable time traces
- !962: Bugfix for L.G.rz,L.G.zz orientation
- !955: Add option for choosing between left and right preconditioning
- !957: MEQ slider equilibrium plot
- !959: Add vacuum equilibria to visualization tests
- !958: fix bug in `meq2eqdsk` definition of `zboxlen`
- !925: Add `meqbdfield` to define breakdown fields
- !952: Split off some common fbt/liu functions
- !946: Add interface to CREATE - JT-60SA
- !936: Implemented steady state formulation of 1D CDE
- !950: Use fixed static tree version for FBT-TCV test runs with fictitious shots

## [6.1.0] - 2024-11-08

- !948: Fix bugs for TCV following update of MDSplus version on tcvdata
- !736: Allow meq2eqdsk to write flux based on `zgrid`
- !947: Add option to overlap part of `z` grid with `x` grid.

## [6.0.3] - 2024-10-18

- !943: Fix loading older RTLIUQE results with `mds2meq`
- !940: Only perform contouring for domain with identified boundaries
- !941: Remove duplicate LIU tests for TCV with `bfct=@bf3pmex`

## [6.0.2] - 2024-10-04

- !937: meqlpack - Fix treatment of empty slices

## [6.0.1] - 2024-09-30

- !933: Small bug fixes for release pipeline

## [6.0.0] - 2024-09-30

- !935: genlib - Update to 3.9.1
- !934: Deactivate inequalities for FBT initial guess by default
- !931: Add wall gap max/min limits
- !932: fbtptcv - Use picard iterations as default
- !929: Add parameter consolidation for `bfgenD` and `bfdoublet`
- !926: Add `IpVQ` and `FtPVQ` computations using volume integrals
- !930: Minor typos in `rtciplasma`
- !927: Always use `F0(3)` for linear ramp in `bfdoublet`
- !922: Generalize and cleanup `meqcompare` behaviour
- !887: Add meqpostq support for mantle domains of doublets
- !916: Add lih2shapobs and lih2qshapobs to generate LIH shape observer matrices
- !919: Various improvements to speedup Picard iterations in `meqopt`
- !879: Fix `OhmTor_rigid_0D` CDE to include induced currents from other plasma domains
- !921: Minor improvements related to FBT TCV doublet generation
- !915: Add anamak shot 88 for doublet with mantle current
- !914: Miscellaneous small cleanups and fixes
- !913: Unify time derivative calculations across meq codes
- !917: Enable parallel computations in `liuanasrv`
- !914: Move `meqmdsopen` from `private/` to main folder
- !908: Add `Ipvacuum` parameter to force lih fit with `Jh=0` if `|LX.Ip|<Ipvacuum`
- !911: Fix `liut` initialization error for `Ie_` and add LIU tests varying `algoNL`
- !910: Detail calculation for verification of FSGI/FSG2 with circular equilibria 
- !907: Bugfix in `fsgi`: add missing factor to `Q5Q`
- !909: Remove duplicate `cycle` field in `fgex.m`
- !906: Fix `bfgenD` handling of case 16/17 when some bf sets have no constraints
- !905: Change shapobs.m to only consider one dsep even if more secondary X-points are present
- !899: Add tests for SQP solving method used in meqopt
- !902: Promote `relax` to `meqp` parameter and use in `meqopt`
- !897: Add generic constraints in LIU
- !898: Fix `ipmwrapper` handling of null equality constraints
- !896: Fix liut iterator mode
- !895: Add example of using bf3imex for custom basis functions in fbt tutorial
- !893: Minor fix IDS interface
- !836: Implement SQP method for LIU
- !889: Bugfix for `LY2CS`
- !878: Add `bfdoublet` multi-domain basis function wrapper for doublets
- !888: Fix doublet-related plotting and add tests
- !886: Make rtcics more robust for both gaps and contours 
- !885: Clean up meqxdoublet and sanitize Ip/IpD, bp/bpD etc handling
- !882: Update `dt` handling in `fget`, remove `fgetk_environment` and associated files
- !876: Add lih2obs: linear observers from lih problem formulation
- !883: Don't overwrite user-given Va in `meqinit.m`
- !881: Minor meqfitprof bugfix
- !872: Domain specific signeo prescription for 1D cde
- !870: Add possibility to change liutnwt parameters
- !875: Use vectorized calls to Jacobian function handle in `gmres_block`
- !877: Refactor meqopt loop and debug
- !873: Enable multi-domain support for 0D CDEs
- !874: Tiny meqdiff bugfix
- !869: Introduce meqopt for FGS/FGE optimizer
- !868: Minor fixes and improvements
- !865: Some fixes and improvements to fbt2pcs
- !860: Enable use of Block-GMRES method in SQP solver for FBT
- !863: Set some matrices to full for octave compatibility
- !867: Remove unused parameters in `shapmex`
- !866: Remove unused or duplicate arguments to meqagcon and meqcde functions
- !864: Use new optimized routine for 2D cubic spline evaluation
- !862: Replace use of `Mby` with call to `meqfbp`
- !861: Refactor use of jacobian function handles in solver routines
- !857: Some fixes and upgrades following detailed FBT-LIU-FGS comparisons
- !859: Various bug fixes
- !856: Check relative path of solver in `meqpath`
- !845: Updates in handling of `fgeF` jacobians
- !850: Add possibility to run LIU/LIH for TCV with `sela` including `TOR`
- !855: Fixes and upgrades for IPM methods
- !848: Add Block-GMRES algorithm to solve linear system with multiple RHS
- !851: Make meqfitprof compatible with multidomain cases
- !842: Add option to prescribe `Iy` directly in FBT and FGE
- !852: Identify duplicate or infeasible direct constraint in `ipmwrapper`
- !844: More flexible preconditioner specification
- !847: Truncate `lX` in meqpost to have `nD` rows
- !518: Extend optional LY field specification to other codes than LIU
- !839: Various `meqpdom` updates and other fixes
- !841: Various FBT fixes
- !835: Add bdet circuit evolution simulator
- !840: Various test suite updates
- !838: Various LIU updates
- !834: Relax requirement of running Newton-GS with ilackner=0/2
- !829: More miscellaneous fixes for `fbt` auxiliaries
- !837: Fix meqplotfancy colormap scaling issue
- !824: Store doublet L,LX in PCS tree
- !818: Add bf mode 17 with jacobian of inequality constraints 
- !833: Plotting and meqmovie updates
- !830: Add current centroids in meqpost and use them in `lih`
- !828: Move `ohcoils` and related parameters to `meq` / `meqptcv.m`
- !827: Fixes to `meqlpack` in case of empty slices
- !819: liu - Add Xt the DML measurement excluding Iy correction
- !822: fbtptcv - Fix conversion of gpba with sign of Ip
- !820: Minor improvements to selectors and interpolators
- !821: Remove duplicate `itera` parameter in `liup.m`
- !825: Use default MDS server and remove function not suported in Octave.
- !810: Add 1D CDE in small diamagnetism approximation
- !826: Fixes to `meqt` and `meqsize` for multidomain cases
- !816: Add bf mode 16 with jacobian of regularization constraints 
- !823: Update file meqsk.m to work with logicals
- !511: Additions of the real time calculation for the vertical instability
- !783: Linesearch for Broyden method + Refactoring Broyden function
- !813: Additions to fbt auxiliary functions towards enabling fbt breakdown
- !814: Improve some `fbt` checks and debugging errors
- !808: Refactor `fgeFJac` to speed-up use of function-handle jacobian with `icsint=true`
- !812: Fix `meqxk` error in case multiple slices are out of bounds
- !811: Fix bug in meqpostq warning for `icsint=true` case
- !805: Include time derivatives in FBT optimization problem
- !804: Moving solver files in a specific folder
- !809: Various updates to doublet generation script
- !807: Enable vacuum solutions in FBT
- !806: Add script to generate various doublet configurations
- !803: Fix treatment of inactive domains in modes 3,91,92 of `bfgenD.m`
- !801: Merge `meqpdom` and `meqpdomlim`
- !802: Improve test coverage for plotting in `fgs_test.m`
- !800: Add missing checks for TCV tests
- !799: Add output of number of iterations in ipm2
- !791: Changes to scalings and linesearch to improve FGS global convergence
- !793: Improve treatment of inactive domains for ag constraints and CDEs
- !797: Add report of domain identification errors in `meqpdom.m`
- !798: Improve treatment of vacuum cases in `meqpdom.m`
- !796: Change fbt `g??a/g??e` defaults to 0/1 and improve `fbt*` help headers
- !790: Add LX.g1??/g2?? to represent FBT time derivative constraints
- !792: Consolidate checks of `gp*` variables in `fbtx.m` 
- !794: Link `ID` to `L.dimID` and make the latter a struct
- !795: Fix several typos
- !787: Add routines for conversion of IDS to MEQ G structure and back
- !728: Add quasi-Newton SQP method for FBT
- !788: Define noq=128 and pq=(0:40)/40 in meqptcv to mirror MDSplus defaults 
- !778: Low level IDS to MEQ routines for coil/vessel discretization
- !786: dIe computation in fgeeig corrected
- !785: genlib - Update to v3.8.0
- !782: Extend bfsp capabilities
- !784: Bug fix: linesearch (eq 3.58)+early exit newton solver
- !781: Set LYall=true as the default for all codes
- !779: Minor FBT test improvements
- !777: genlib - Update to v3.7.0
- !776: Improve condition to allow tests using TCV data
- !775: Change order of asxy jacobians, do not always compute all jacobians
- !774: Only load TCV limiter spline coefficients from MDSplus if mdsopen is available
- !773: shap - Only replace extremum with boundary point if it is further than the current one
- !771: Refactor `fgelin` tests
- !772: Remove obsolete `fgslin` function and associated tests
- !769: Remove dependence on polyfun toolbox in `vertices2meq`
- !768: Remove performance-critical assert() calls
- !770: Makefile - Remove include subdirectory from VPATH
- !763: Update `fbtxana` to reduce FBT residuals at convergence
- !767: Allow passing previous `aq/aW` values to `rtcics` 
- !766: Enable use of direct `ag` constraints in FGEL
- !765: Refactor `liuxana` and `liusim` tests
- !764: Rename variables linked to Br and Bz computation
- !762: Minor fixes for octave compatibility + Makefile/README cleanups
- !759: Fix computation of `Jxdot` in `fgeFlin` with `anajac=false`
- !761: Bugfix: use `0.5*|Fx|^2` as objective function of `evaluate_F`, fix `P.relax` use
- !758: Check LIUQE.M nodes are filled in `mds2meq`
- !754: Extend FGEL to new `algoNL` options
- !757: Minor fge/fgs plotting fixes
- !755: Make sure restarted state is valid before proceeding with Newton iterations 
- !750: Improve line-search algorithm and consistently use 2-norm in newton/broyden solvers
- !753: Add compensation of removed vessel currents by PF coils in `meqinit`
- !752: Unify `fgeF` with `fgsF_GS`, add option `algoNL=all-nl-Fx`
- !751; Fix Inf/NaN values in FGS jacobian with bfct=bffbt
- !746: Add various FGS/FGE solver options and improve debugging behaviour
- !730: meqpdom - Restore `isaddl=0` option
- !747: Minor fixes to `solveF` and associated tests for linear systems
- !649: Implement fgeFJac to compute the action of the fgeF jacobian
- !744: meqFx - Unify gsxe mode 1 and 2, add `gsxetol` parameter
- !743: Fix bug in assigning default settings in `fbtx`
- !742: Simplify and document FBT cost function weight parameters
- !740: Extend `meqalgoNLc` to treat external inputs and static/dynamic states
- !741: Introduce state and residual scaling to `liuF`
- !739: Fix ipm2 convergence issues
- !738: Rename FBT regularisation parameters
- !644: Add first implementation of shape observer functions
- !737: Introduce `meqalgoNLc` to compute necessary data required for each NL operator
- !731: IPM consolidation
- !734: Tiny bugfix for `fbtlsqsolve>ineq_to_bounds`
- !733: Correct `meqlsqsolve` scaling of cost function
- !732: Various FGE fixes
- !702: Introduce basic GSpulse algorithm into `fbt`
- !729: Performance improvements for fgeF
- !727: Unify `meqpdom` for singlet and doublet
- !726: Unify FGE and FGS debug output and include vacuum
- !725: Optimize `newton_solver` to avoid extra F or J evaluations
- !724: Fix RZP simulation in `anamak_rzp_control`
- !708: Improve Broyden convergence
- !710: Optimize assembly of `fgeF` jacobian
- !723: Fix `anamak_rzp_control` tutorial following !659 regression
- !721: Update computation of meqpdom jacobians and use sparse matrices
- !720: Cleanup meqplotliu and add it to visualization tests
- !709: Move CDE to FGE
- !690: Merge `fgeF` with `fgsF`, remove `fgsF` and related functions 
- !716: Improve domain identification in liutsim
- !718: Separate debug and debugplot 
- !659: Change CDEs to work more like ag constraints
- !717: Fix bug introduced in !683 causing unwanted computations of the jacobian when `algoF=jfnk`
- !714: Extend fixture to write to temporary TCV trees to the RESULTS tree
- !715: Fix bug in `vessel_tests`
- !712: Move all C header files to include folder 
- !711: Ignore more tests using TCV data when unable to connect to server
- !707: Implement influence of external conductors in computational grid in `fgsF_GS`
- !703: Handle redundant or infeasible equality constraints in ipm
- !686: Refactor and update `fge_environment` related files
- !705: fgs - Implement jacobian against Ie,Co for `fgsF_GS`
- !706: Fix warning call syntax
- !683: Add Broyden solver as optional solveF solver
- !701: fbt - Add and use fixture to write to temporary TCV PCS trees
- !695: Minor meqgsave/meqgload updates
- !700: genlib - Update to v3.6.3
- !699: Fix bug in choice of IPM mode with equality constraints in FBT
- !694: Group and improve definition of nominal values for variables
- !693: Split definition of FBT optimization problem
- !604: Use meqagcon to compute ag coeffients in FBT

## [5.1.8] - 2024-07-25

- !903: Hot fix for `liugtcv` to use probe selection for Ip estimator too

## [5.1.7] - 2024-04-24

- !854: Hot fix for storing FBT doublets during TCV shot preparation

## [5.1.6] - 2024-01-22

- !760: Update TCV fictitious PCS shot range

## [5.1.5] - 2023-12-19

- !745: psiwtcv - Use PsiTbx results for axes and X-points characteristics

## [5.1.4] - 2023-11-14

- !714: Hot fix for bug in size of inner/outer midplane radii

## [5.1.3] - 2023-11-14

- !714: Hot fix for bug in calling routines writing to TCV RESULTS tree

## [5.1.2] - 2023-10-30

- !697: Hot fix restoring post-processing with Psi-Toolbox when `iterq=0` and writing to TCV trees

## [5.1.1] - 2023-10-27

- !695: Fix incompatibility with R2017a in `fgslin_full_test.m`

## [5.1.0] - 2023-10-26

- !691: Make `rzp_test` more effective by adding error identifiers
- !685: Add iterator mode for fget
- !688: Introduce function to get FGS/FGE state from LX
- !687: meqplotfancy - Fix plotting of vessel segments
- !679: bfct - Remove assumption that one basis function is for Pprime or TTprime
- !684: Fix missing outputs in fsgimex.m
- !678: Bug fixes for meqsize and meqxconvert
- !658: Generalize computation of FGE linearization
- !656: tcv - Replace Psi-Toolbox based post-processing with MEQ implementation
- !674: Minor fixes for octave compatibility 
- !673: Fixed qA constraint analytical jacobian
- !672: genlib - Update to v3.6.2
- !670: Remove temporary directory after RZP codegen test
- !669: Minor tooling updates and bugfixes
- !668: Fix scaling of direct ag constraint residual
- !667: Minor changes including removing tab characters
- !665: Add derivatives with respect to parameters (currents/constraints/voltages/previous state)
- !655: Add computation of flux-surface volume, area and lateral area from contours
- !664: Add option to use ipm() as QP solver in FBT for users without optimization toolbox
- !663: Fix concatenation of transfer matrices in `vertices2meq`
- !660: Change fgex to output LX structure with numel(t) time slices
- !661: Remove need for preallocation in `vertices2meq`
- !654: Extend FSGI to include integrated current, r barycenter, contour length, Q5 
- !652: LY2Ain routine moved to the hybrid project
- !646: Vectorize qintmex, use it in fbtt to compute plasma contribution
- !651: Update `fbndmex` to return index of selected X-point/limiter point
- !642: Add `meqik` to insert equilibria into existing sequences
- !621: Alternative for FGS operator with sparse Jacobian
- !648: Enable computation of all `asxymex` outputs derivatives in `asxyJac`
- !645: Avoid duplicate calls to `meqFx` and `meqpdom` when computing `fgsF` jacobian 
- !647: Performance fix for computation of green functions in fbtt
- !639: Miscellaneous fixes for fbt auxiliaries
- !635: Add jacobian of cubic spline interpolation routines for plasma domain identification
- !624: Add derivatives of CDE equation
- !643: Add explicit software name in CLAs
- !638: Add IgnoredFilenames property for `meq_check_headers`
- !629: Add derivatives for bf modes 2 and 3
- !628: Add generic finite difference jacobian comparison and convergence routines
- !631: Add path-checking function to direct liu/fbt/fgs/fge/rzp calls
- !636: Improve instructions and options for Windows and MacOS installation
- !634: Various fixes for meqgload/meqgsave
- !633: Fix bug in computation of Ia scaling
- !627: Fix error in meqpostq when no axis domain is present
- !622: Generalize computation of finite difference jacobian estimates in jacfd
- !625: Change dlst to be a multiplication by the sparse matrix returned by dlstc
- !623: Add option for implicit step in meqpassevo for FBT passives
- !620: Update requirements for check of L.lin presence in FGE
- !602: Add `meqplotseq.m` and improve `visualization_tests`
- !617: Introduce cizr to compute all meqintQ integrals at once, partly reverts !574
- !618: Implement fgsF jacobian for multiple domains
- !616: Implement basis function derivatives for bfgenD
- !619: GitLab CI config - remove deprecated `CI_BUILD_*` variables
- !615: Add mode 4 and 8 to bfgenD
- !613: Cleanup meq jacobian test classes
- !612: Add mode 11 and 15 to all basis function sets
- !614: Update computation of meqFx jacobian with gszr/nfdb treating multiple problems at once
- !607: Fix FBT in case control point overlaps with grid
- !608: Add meqdiff for displaying differences between equilibria
- !610: Add `GS_vacuum_analytic.m` for analytic vacuum GS solution
- !605: Add Contributor License Agreemeent, CITATION.md
- !609: Fix reducing the Newton step size in solveF
- !606: Fix jacobian tests following solveF refactoring
- !601: Standardize basis function definitions
- !599: Refactor solveF to be more flexible
- !603: Add G.Tnv to separate various passive structure components
- !600: Change handling of multiple floating point precisions in source files
- !581: Add coil equality constraints in FBT and OH coil support for FBT-TCV
- !598: Reduce usage of multiple processes or threads in CI jobs
- !587: Improve meqinterp and add fbtinterp / update genlib to v3.5.0
- !597: Add CI jobs for Octave build and minimal test
- !596: genlib - Update to v3.4.0
- !512: Introduce fgsF/fgeF state scaling
- !594: Change default compiler to icx, keep spc builds with icc
- !593: Enable all compiler warnings and enforce warning free compilation
- !592: In MEX-files initialize pout values with NULL
- !590: Analytical ag constraint jacobians
- !591: Corrected computation of Ig3 in bfabmex.c and bfef.c
- !585: Update solveF to use information about jacobian structure
- !584: Fix fbtpana parameter precedence and limm-related tests
- !587: README.md: add section about good practices for merge requests
- !578: Add ilackner option to change behaviour of meqfbp
- !586: Fix fgegtcv to accept as vessel representation also ex and vx
- !583: Throw error when attempting to pass deprecated FBT LX parameters for TCV
- !582: Extend meqFx jacobian to all gsxe options
- !572: Add a simple model for passive currents in FBT
- !577: Use semi-analytical expressions to compute FGE linearization
- !579: Set selc to true by default for TCV to return G.Tca matrix
- !575: Update meqTyg and meqagconfun to optimize semi-analytical jacobian assembly
- !574: Update vizr/bbox:
  - Update vizr to return integrals as function of normalized flux and domain
  - Update bbox to return bounding box as function of domain
- !571: solveF - refactor GMRES variants
- !573: liut - fix bug where residuals were corrupted in debug output of last slice
- !569: Partly undo generalization of G.Tuv (!567) to keep enforcing G.Tvu=G.Tuv'
- !570: Add dedicated anciliary matrices for meqFx with gsxe=3
- !568: mds2meq - Add warning for cases where FBTE-FORTRAN runs did not store Ia
- !514: Implement semi-analytical jacobian for FGS and FGE
- !567: Improve error handling in meqg/mds2meq and allow generic G.Tuv
- !565: Update `_octave/contains.m` behaviour when pattern is empty, update `malloc` syntax for C++ compatibilty
- !561: Add MEQ Geometry cheatsheet documentation/CHEATSHEET.md
- !563: Fix typos in comments and warning/error messages. No functional changes.
- !564: Remove superfluous return statement in `vizr.c`
- !562: genlib - Update to v3.3.0
- !556: Enforce stricly positive number of basis functions
- !560: README - Clarify use of the MATPATH variable with make
- !552: FGE non-convergence recovery logic - Keep previous timestep
- !555: Add experimental support for Octave
- !553: flcs - Fix unconstrained number of threads in calls to bspsum/bsp2deval
- !550: fbtptcv - Suppress undesired output

## [5.0.0] - 2023-01-16

- !548: Makefile - Enable Windows build
- !545: fbtptcv - update algorithm providing guess for gpb value of legacy control points
- !546: Enable time-varying gpdw in FBT
- !544: Refactor post-processing and add [r|z,r|z,max|min]
- !307: Add R,Z,Ip + coil feedback controllers
- !542: Updates to lih and field post-processing
- !543: fget - Fix bug in consecutive non-converged time steps counter
- !541: Export MEQ results to G-EQDSK file format
- !539: Reuse LX data when possible in rzp tests
- !540: mexargs - implement checks of numeric type for scalar inputs of MEX-files
- !538: Correctly reuse binaries from other build jobs in CI job publishing documentation
- !521: Implement cubic spline interpolation for identification of limiter/X points and FS contours
- !536: Introduce G.Dda to make FBT Dax (current dipole matrix) customizable
- !537: Minor genlib and makefile-related updates
- !533: Restore solveF behaviour difference for cgs/mgs
- !531: Cleanup FBT parameters, add meqx and fbtxtok
- !530: Eleven FBT equilibria for Anamak + fbtxplot/fbtplot
- !528: Add fbtxdisp and improve fbt help
- !523: Refactor Arnoldi Iterations in solveF.m
- !506: Minor miscellaneous fixes
- !527: Improve fbt fitting error reporting
- !516: update meqxconvert to return minimal liu inputs
- !526: Add copyright headers to all files
- !525: Add check for help header presence in meqhelp test, add Ini to fget help
- !524: solveF - use the same inner residual tolerance for all Gram-Schmidt methods
- !522: meqwtcv - Store flux with F=0 at R=0 convention for doublets
- !519: asxy - refactor interpolation of flux in both C and MATLAB sources
- !520: Change boundary condition of radial spline, improves accuracy of metric coefficients at the edge
- !513: Introduce Picard plasma convergence loop for FGS/FGE solvers
- !517: Clarify use of integer types in C source files
- !505: Add checks for C MEX-file arguments using the mexargs project via genlib
- !510: Minor visualization improvements
- !509: Allow FBT to run without vessel definition
- !508: Improve documentation related to coordinate systems
- !515: CI config syntax switch to rules instead of only/except
- !507: Improve meqgsave/meqgload
- !504: Add tool for converting polygon vessel description into filaments

## [4.5.2] - 2022-07-11

- !503: Enforce using the latest static tree version when preparing the MODEL shot with FBT
- !501: Change fbtt residual definition to match liut's and better handle quadprog failures
- !500: Fix bug when removing inequality constraints in fbtt
- !499: Add calculation of B*za/B*zu matrices in meqg
- !498: Fix bug in `dFdI` preventing `fgel` calls with `nu<3`
- !475: Add fast rzip version for RT use
- !497: Fix mds2meq when retrieving FBTE.M data
- !496: Update to latest SPC CI template
- !495: Generate HTML code coverage reports and archive them for released versions only
- !492: Fix Makefile dependencies for published documentation, run parallel make for CI builds
- !493: Enable choosing TCV static tree version via new parameter 'static'
- !491: Allow default time selection in liu(tok='TCV')
- !490: Fix tests of computation of B field
- !487: Extend default x grid 1/2 cell beyond limiter
- !484: Change liutslx.slx to look for `configurationSettings` in base workspace
- !488: Various `Makefile` updates
- !485: Check for `genlib` presence in `meqg.m`
- !482: Fixes for running LIUQE on old TCV shots
- !481: Implement tests for ipm.m and fix ipm mode=1,5
- !480: Improve scaling of quadprog problems in FBT
- !470: Skip FGS calculation at initialization of RZP
- !478: Fix publish-documentation job conditions

## [4.5.1] - 2022-04-01

- !368: First tutorial and automated publishing of html documentation
- !469: Further minor `CHANGELOG.md` fix
- !468: Missing `CHANGELOG.md` fixes
- !472: Fix meqxconvert bug to conserve sum(Iy(:)) upon grid change
- !473: Change SPC CI build tags
- !464: Add more documentation to top-level functions

## [4.5.0] - 2022-02-02

- !466: Add meqreprocess
- !461: Compute Br,Bz for various grids as part of `meqpost` and change `P.fancyplot` to `P.izgrid`
- !400: Add rzp rigid-body plasma + conductor current model
- !465: Minor clean up of SCD interface

## [4.4.2] - 2021-12-21

- !463: Hotfix to change `get_scd_mems` calls following update of SCD toolbox

## [4.4.1] - 2021-12-17

- !460: Miscellaneous fixes to `meqplotfancy`, `mds2meq` and `liusimc`
- !459: Fix interpolation to compute q95 in `meqpostq`.
- !458: Minor correction to meqt.m documentation for aminor

## [4.4.0] - 2021-11-29

- !455: Add option to get default parameter values for TCV liu run.
- !454: Generalize use of liut with a custom initial guess.
- !452: Fix Q4Q unit in meqt.m
- !451: For TCV give precedence to `selx` in choice of `X` grid.
- !450: Remove circular dependencies between P and G structures.
- !435: Move loading of `dz`-related G quantities from `meqgtcv` to `liugtcv`
- !449: Add size checks for arguments of asxymex to avoid exceptions
- !448: Fix bug where fetype='bil' FE always extended to the edge of the grid
- !447: Fix bug where zl parameter was ignored in liu for TCV
- !445: Update description of output quantities in `meqt.m` and update meqhelp_test
- !446: Cleanup bfct,bfp defaults and bugs thereby exposed
- !443: Make use of genlib subdirectory optional in `meq_fixture`.
- !441: Add option to get the spatial derivatives of the magnetic field created by the external currents in `meqg`
- !442: Fix FBT parameters initialization for TCV shots prior to 56469 where `gp*` parameters are not stored

## [4.3.0] - 2021-10-05

- !440: Fix HTML code coverage report generation and publication
- !439: Fix deployment pipelines following code coverage additions
- !436: Various improvements to LIUQE output and plotting for plasma-less slices
- !437: Add meqplotfull.m plotting function
- !434: Remove SCD folder paths since now deployed on lac crpptbx
- !433: Minor meqgplot cleanups
- !432: Update documentation of the radial grid parameters
- !430: Fix tests with missing TestTags
- !431: Fix CI pipeline to generate and publish HTML code coverage report
- !428: Add CI job to merge code coverage reports and provide metric to GitLab
- !429: Fix broken path to SCD tools
- !338: Generate code coverage reports as CI job artifacts
- !427: Refactor `asxy` to reduce code duplication (#239)
- !426: Fix compilation with debug information (#484), add BUILD option to Makefile
- !425: Fix bug where `lasy` parameter to identify X-points outside of limiter was ineffective

## [4.2.4] - 2021-09-10

- !423: Fix bug in asxy where null points estimates could end up too far from the original cell (#231)
- !422: Fix bug in asxy where 2 axes were identified in cells with equal center values (#245)
- !421: In FBT if solution without inequality constraints enforced satisfies them then keep it

## [4.2.3] - 2021-08-30

- !419: Allow FBT and LIU to return LY containing converged and failed slices
- !413: Refactor `meqg.m` for compactness and efficiency
- !414: remove `try/catch`, better condition `fbt` LSQ problem and use `quadprog`
- !418: Fix small mds2meq bug for RTLIUQE case
- !412: Add meqgsave/meqgload for geometry saving/loading
- !411: Fix CHANGELOG omission of !397 for v4.2.2

## [4.2.2] - 2021-07-18

- !408: Fix minor bug in meqsk related to nan padding size
- !409: Fix plotting bug preventing meqplott plotting of multiple FW in some cases
- !387: Extend fgess to include linearization w.r.t. constraints and CDE
- !405: Fix bug in `meqFx` when `IyD` was only zeroes. Add parameter to allow current holes.
- !404: Fix currently opened tree bug in `mds2meq`.
- !401: Improved CREATE geometry/vessel description and plotting
- !397: Fix bug related to scaling of FGE preconditioner
- !396: Fix bug where liut debug fails when called on first iteration
- !395: Enable storing of `LY.Vp` in `VOL_PL` node in `meqwtcv.m`.
- !394: Fix bug where shot was not stored correctly in `L` and `LX` for `tok='ana'`
- !392: Re-add Is (segment current) as output

## [4.2.1] - 2021-06-01

- !389: Minor FGE/FGS/FBT shot and time handling cleanups

## [4.2.0] - 2021-05-17

- !385: Retroactively fix and update CHANGELOG.md
- !381: Disentangle `meqpdom` mode parameters and add optional quadratic interpolation on limiter
- !382: Minor cosmetics and cleanups
- !365: Fix name of `shap` block outputs.
- !379: Add p>0 constraint in liuqe Simulink version.
- !377: Remove option to run `gszr` with empty `Fb` to set zero boudary condition (Follow up of !355).
- !373: Add nFW>1 case in Simulink and anamak shot 6 to better test it.
- !378: Fix version requirements for `mkcsf`, R2019a or later is now required.
- !372: Updates to bring into SCD2021 operation
- !376: Fix scale of `PpQ/TTpQ` in `mds2meq` for `source='FBTE'` when `FBTE.M` was used.
- !371: Improved slx/sldd and Simulink configuration handling, move Simulink to R2019a, unify lih/liusimc.
- !370: Better defaults and checks for bfp.
- !369: Improved FBT points for Anamak shot 4 (double null).
- !360: Updates related to reading SCD and other data
- !367: Fix condition for using preconditioner in case of multiple equilibria for `FGS`.
- !366: Fix uncaught mkmeqh/mkcsf errors in Makefile.
- !361: Fix uninitialized Fx variable in `gszr` causing problems in LIUQERT runs.
- !355: Fix bug where sign of Ip could be zero in Simulink model.
- !354: Update genlib version, for improved `greenem` accuracy for close loops.
- !352: Minor .gitlab-ci.yml improvements.
- !351: Fix source of LIUQE parameters in `mds2meq`.

## [4.1.0] - 2021-03-30

- !348: Provide complete `L` structure as output of `mds2meq` for TCV shots.
- !347: Fix FGS initial guess from input `LX` structure.
- !334: Implement `OhmTor/OhmTor_rigid` options for FGE current diffusion equation based on Ohm's law toroidal projection.
- !346: Add CHANGELOG.md file
- !344: When loading legacy FBT parameters for TCV shots, discard control points for strike points from plasma initial guess.
- !342: Remove persistent variables in `liut`. Use `IyD` as state variable in liutnwt.
- !341: Small fix in `meqxconvert`.
- !337: Cleanup SLDD handling in `liusimc/lihsimc`. Change dummy time handling.
- !336: For TCV shots, FBT loads additional parameters from the `\mgams:debug:p1` node.
- !335: Fix bug in `fgex` where signeo was overwritten by `fgeinit`.
- !332: New parameter `ipmeas` to use independent Ip measurement in liuqe, treat this correctly in `liusim`.
- !331: Allow `liusim` to run when no external conductors are in the computational grid.
- !330: Make help section of `mexm` files uniform.
- !327: In `rtci`, avoid points crossing domain boundaries.
- !328: Fork `fsgimexm` from `fsgimex` and add tests.
- !329: Add tests for `gszrmexm`.
- !302: In `liuxtcv`, load power supply voltages and clean test for time compatibility.
- !322: Treat correctly circular windings in `meqg`.
- !321: Correct inductive coil direction for FGE initial state.
- !319: Add coupling between DML and plasma current in `liusim`.
- !317: Add `limm` parameter in FBT for introducing a margin with respect to the different coil current limits.
- !318: In the test suite, create a separate `meq_simulink_fixture` to be used with Simulink tests only.
- !315: Set default value of `iters` to 48 for liuqe's iterative solver.
- !314: Fix plasma domains extending past the limiter for single axis cases.
- !312: Fix FBT discarding `gp*` variables for TCV model shot.

## [4.0.1] - 2021-02-09

- !310: Use EQUIL parameter tree by default on TCV for LIUQE. Finalize `.gitlab-ci.yml` settings for deployment.

## [4.0.0] - 2021-02-09

First release since move to Gitlab and first release at TCV since July 2018.
