function iterdisp(xk,gk,vk,xdot,res,dt,it,inewt,trap,model,params)

if mean(params.tgrid)>=0.5
    tscal = 1;   tunit=''; % s
else
    tscal = 1e3; tunit='m'; % ms
end

Ipl = eval_Ipl(xk,gk,vk,model,false);
Ip = Ipl(end);
if Ip >= 0.5e6
    Iscal = 1e-6; Iunit ='M';
else
    Iscal = 1e-3; Iunit ='k';
end

te = eval_te(xk,gk,vk,model,false);
ti = eval_ti(xk,gk,vk,model,false);
ne = eval_ne(xk,gk,vk,model,false);
q    = eval_q(xk,gk,vk,model,false);
upl = eval_psi(xdot,gk,vk,model,false);
dupldrho = eval_psip(xdot,gk,vk,model,false);
Ibs  = int_SjdotB(trap.jbsB,gk,model,model.rgrid.nrho);
Iaux = int_SjdotB(trap.jauxB,gk,model,model.rgrid.nrho);
Ini  = Ibs+Iaux;

if ~mod(it-1,params.debug.iterdisp*20)
    fprintf('%7s ','  it');
    fprintf('%7s ','telaps');
    fprintf('%4s ','newt');
    fprintf('%7s ','res');
    
    fprintf('%3s[%1ss] ','t',tunit);
    fprintf('%3s[%1ss] ','dt',tunit);
    fprintf('%3s[%sA] ','Ip',Iunit); % Ip
    fprintf('%3s[%sA] ','Icd',Iunit); % Icd
    fprintf('%3s[%sA] ','Ibs',Iunit); % Ibs
    fprintf('%3s[%sA] ','Ioh',Iunit); % Ioh
    
    fprintf('%7s ','qe'); % q edge
    fprintf('%7s ','qmin'); % q 0
    fprintf('%7s ','q0'); % q 0
    fprintf('%7s ','Vl[V]') ;
    fprintf('%7s ','Te0[keV]') ;
    fprintf('%7s ','Ti0[keV]') ;
    fprintf('%7s ','ne0[e19]');
%    fprintf('%3s[%sJ]','Wi',Iunit); % Wi
%    fprintf('%3s[%sJ]','We',Iunit); % We
    fprintf('%7s ','f_ss '); % steady stateness factor
    fprintf('\n')
end

fprintf('%7d ',it);
fprintf('%7.2g ',toc);
fprintf('%4.1d ',inewt);
fprintf('%7.1e ',res);
fprintf('%7.3g ',params.tgrid(it)*tscal);
fprintf('%7.3g ',dt*tscal);
fprintf('%7.3g ',Ip*Iscal); % Ip
fprintf('%7.3g ',Iaux*Iscal); % IAUX
fprintf('%7.3g ',Ibs*Iscal);  % IBS
fprintf('%7.3g ',(Ip-Ini)*Iscal); % Ioh

fprintf('%7.3g ',q(end)); % q edge
fprintf('%7.3g ',min(q) ); % q min
fprintf('%7.3g ',q(1)); % q0
fprintf('%7.1e ',upl(end)) ;
fprintf('%7.2f ',te(1)/1e3) ;
fprintf('%7.2f ',ti(1)/1e3) ;
fprintf('%7.2f ',ne(1)/1e19) ;
%fprintf('%7.2f ',profiles.WI(end,:)*(model.psi.Lampgauss*Psihat).^2*Iscal); % Wi
%fprintf('%7.2f ',int_Wpol((model.psi.Lampgauss*Psihat).^2,gk,model,model.rgrid.nrho)*Iscal); % Wi
%fprintf('%7.2f ',profiles.VI(end,:)*(1.6e-19*(model.te.LamTegauss*Tehat).*(model.te.LamTegauss*nehat))*Iscal); % We
%fprintf('%7.2f ',int_V(1.6e-19*(model.te.Lamgauss*Tehat).*(model.te.Lamgauss*nehat),gk,model,model.rgrid.nrho)*Iscal); % We
fprintf('%7.1e ',norm(dupldrho)); % f_ss
fprintf('\n')