function hl = labelff(varargin)
% h = labelff(string,xy)
% or 
% h = labelff(axishandle,string,xy)
% puts x or y label "string" inside axes in a corner. 
% xy = 'x' or 'y'

if nargin==1;
  error('insufficient inputs')
elseif nargin>1
  if ishandle(varargin{1})
    hax = varargin{1}; % axis handle
    string = varargin{2}; 
    xy = varargin{3};
  else
    hax = [];
    string = varargin{1};
    xy = varargin{2};
  end
end
  
switch xy
  case 'x'
    if ~isempty(hax);
      hl = xlabel(hax,string);  
    else
      hl = xlabel(string);
    end
    
    set(hl,'units','normalized','position',[0.99 0.01],'horizontalalignment','right','verticalalignment','bottom')
  case 'y'
    if ~isempty(hax);
      hl = ylabel(hax,string);
    else
      hl = ylabel(string);
    end
    set(hl,'units','normalized','position',[0.01 0.97],'horizontalalignment','left','verticalalignment','top','rotation',0) 
  otherwise; 
    error('choose x or y')
end