% simple chie model as a function of psi
function [tau] = scaling_law(model,Ip,ne,Ptot)

%%
%ip = model.out.CIp(:,end)*Psihat;
ip = Ip;
ne_vol_avg = ne/1e19; % volume averaged
neavg19 = ne/1e19; % line averaged

total_powerMW = 0.5;

R0_eff = model.profiles.eq_params.R0;
B0_eff = model.profiles.eq_params.B0;
z_eff = model.profiles.eq_params.Zeff;
a_eff = model.profiles.minorradius;
kappa = model.profiles.kappa;
delta = model.profiles.delta;

% some scalings (copied from chie_tcv_to_nodes)
RLWcst=0.012 .* (abs(ip)/1e6) .* (R0_eff .* a_eff.^2 .* kappa).^0.5 ./ z_eff.^0.5;

taue_RLW=2.6e-2 .* (ne_vol_avg').^0.75 .* z_eff.^0.25 .* B0_eff.^0.5 .* (abs(ip)/1e6).^0.5 ...
    .* (R0_eff .* a_eff.^2 .* kappa).^(11./12.) ./ ...
    total_powerMW + RLWcst;

% taue from ITER98L, IPB paper NF 99
taue_98L=0.023.*(abs(ip)/1e6).^0.96 .* B0_eff.^0.03 .* total_powerMW.^(-0.73) ...
    .* neavg19.^0.40 .* 2.^0.2 .* R0_eff.^1.83 .* (a_eff./R0_eff).^(-0.06) .* kappa.^0.64;
  
tau = taue_RLW;