function [varargout] = prad_manual(varargin)

if nargin == 0;
    module_config = struct(...
    'modeltype' , 'manual'  ... % default module
    ); % load default params
  
    varargout{1} = 'prad'; % type
    varargout{2} = module_config; 						 
    return %empty call, probably to get default structures

elseif nargin==2
    module_config = varargin{1};
    module_params = struct(...
    'active',true,...
    'implicit',false,...
    'profs',0);
    mm.name = mfilename;
    mm.modeltype = module_config.modeltype;
  
    varargout{1} = mm;
    varargout{2} = module_params; % return appropriate parameter structure
    return
elseif nargin==4;       % change this depending on number of inputs to module
    %stap = varargin{1};
    it = varargin{2};
    model = varargin{3};
    pr = varargin{4}; % distribute inputs
else
    error('must call with 0 or 4 inputs');
end

if ~pr.active
  varargout{1} = zeros(model.rgrid.nrhogauss,1);
  if nargout>=2
    varargout{2} = zeros(model.rgrid.nrhogauss,model.dims.nx);
  end
  
else
  
  if numel(pr.profs)==1
    % constant value
    Prad = zeros(model.rgrid.nrhogauss,1);
  elseif size(pr.profs,1) == model.rgrid.nrhogauss && size(pr.profs,2) >= 2; % for time-dependent profile
    if size(pr.profs,2) >= it;
      Prad = pr.profs(:,it);
    else
      error('wrong size for Prad, must at least be [%d x %d]',model.rgrid.nrhogauss,it)
    end
  else
    Prad = pr.profs; % Rho-dependent but time-independent profile
    if ~all(size(Prad)==[model.rgrid.nrhogauss,1]);
      error('wrong size for params, must be %d x 1]',model.rgrid.nrhogauss)
    end
  end
  varargout{1} = Prad;
  
  if nargout==2
    varargout{2} = zeros(numel(Prad),model.dims.nx);
  end
end
end
