#!/bin/make -f
QLKNNDIR+
MKLROOT+
FC+
MEX+

# gfortran
DEBUG_GFORTRAN_ALL=
DEBUG_GFORTRAN_IGNORE_WARN=
FFLAGS_GFORTRAN_QLK=-ffree-line-length-none -cpp
FFLAGS_GFORTRAN_QLKNN=-flto -ffast-math -fwhole-program -m64
ifeq ($(DEBUG), 1)
  DEBUG_GFORTRAN_ALL+=-g -Wall -Wextra -Warray-temporaries -Wconversion -fbacktrace -ffree-line-length-0 -fcheck=all -ffpe-trap=zero,overflow -finit-real=nan
else
  FFLAGS_GFORTRAN_QLKNN+=-O3
endif
FFLAGS_GFORTRAN=$(FFLAGS_GFORTRAN_QLK) $(FFLAGS_GFORTRAN_QLKNN) $(DEBUG_GFORTRAN_ALL) $(DEBUG_GFORTRAN_IGNORE_WARN)

# Working with `module unload pgi openmpi; module load ifort/12.0 openmpi-ifort-12.0/2.1.0`
DEBUG_IFORT_ALL=
ifeq ($(DEBUG), 1)
  DEBUG_IFORT_ALL=-g -check all -fpe0 -warn -traceback -debug extended
endif
FFLAGS_IFORT_QLK=-O1 -fpp
FFLAGS_IFORT=$(FFLAGS_IFORT_QLK) $(DEBUG_IFORT_ALL)

ifeq ($(USE_MKL),true)
  MEX_INTEL_MKL_LINK= ${MKLROOT}/lib/intel64/libmkl_gf_lp64.a ${MKLROOT}/lib/intel64/libmkl_sequential.a ${MKLROOT}/lib/intel64/libmkl_core.a
  INTEL_MKL_LINK= -Wl,--start-group ${MKLROOT}/lib/intel64/libmkl_gf_lp64.a ${MKLROOT}/lib/intel64/libmkl_sequential.a ${MKLROOT}/lib/intel64/libmkl_core.a -Wl,--end-group -lpthread -lm -ldl
  INTEL_MKL=-m64 -I${MKLROOT}/include
  FFLAGS_GFORTRAN += -DUSE_MKL
endif


ifeq ($(FC),gfortran)
  FFLAGS=$(FFLAGS_GFORTRAN)
else ifeq ($(FC),mpifort)
  FFLAGS=$(FFLAGS_GFORTRAN)
else ifeq ($(FC),ifort)
  FFLAGS=$(FFLAGS_IFORT)
endif

ifeq ($(PARALLEL),mpi)
  MPI_FLAGS=-DMPI
endif