function [ ttp] = eval_ttprime(x, g, v, model,gauss)
% function [ TTprime] = eval_TTprime(x, g, v, model,gauss)
% TT' for integration with equilibrium code
% Based on A. Merle's sawtooth notes, uses flux surface averaged GS
% equation.
%
% Outputs:
% ttp: T*dT/dpsi
% with T = RBphi


%% compute TT' from <jphi/R> and p'
pprime = eval_pprime(x,g,v,model,gauss);
g3 = eval_g3(x,g,v,model,gauss);
% jphioR = <jphi/R>
jphioR = eval_jphioR(x,g,[],model,gauss);

% Eq on page 2 from Merle notes
ttp = -1./g3.* (1/(2*pi)*4e-7*pi*jphioR + 4e-7*pi*pprime);

debug_plot = false;
if debug_plot
eval_debugging_plot(mfilename,'psiN', hf, hax,x,model,gauss, pprime,  'pprime', g3, 'g3', jphioR, 'jphioR', ttp, 'ttprime');
end


return

